% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Incidence.R
\name{Incidence}
\alias{Incidence}
\title{Solar Incidence Angle}
\usage{
Incidence(DOY, Lat, Lon, SLon, DS, Slope, Aspect)
}
\arguments{
\item{DOY}{Day of year}

\item{Lat}{Latitude (in degrees)}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}

\item{Slope}{Site slope in degrees}

\item{Aspect}{Site aspect with respect to the south in degrees}
}
\description{
This function returns solar incidence angle (in degrees) for a given day of year and location and site slope and aspect. The solar incidence angle is the angle between sun's ray and the normal on a surface.
}
\examples{

#Calculating solar incidence angle for two consecutive days on 45 degree latitude and
# 10 degree longitude

DOY <- seq(0, 2, .05)

theta <- Incidence(DOY, Lat = 45, Lon=10, SLon=10, DS=0, Slope = 10, Aspect = 0)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, theta)

}
\keyword{Angle}
\keyword{Incidence}
\keyword{Solar}
