% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobolnp.R
\name{sobolnp}
\alias{sobolnp}
\title{Nonparametric Sobol Estimator with Bootstrap Bandwidth}
\usage{
sobolnp(Y, X, bandwidth = NULL, bandwidth.compute = TRUE,
  bootstrap = TRUE, nboot = 100, ckerorder = 2, mc.cores = 1)
}
\arguments{
\item{Y}{Response continuous variable}

\item{X}{Matrix of independent variables}

\item{bandwidth}{If \code{bandwidth.compute = TRUE}, it sets the starting bandwidth to find the bootstrap bandwidth. If \code{NULL} the least-square cross-validation bandwidth is used.
If \code{bandwidth.compute = FALSE}, it will use the values provided fixed over all the simulation. Defaults to \code{NULL}.}

\item{bandwidth.compute}{Logical value. Indicates if the bandwidth should be estimated or not. Defaults to \code{TRUE}.}

\item{bootstrap}{Logical value. Indicates if the estimation should be with bootstrap or not. Defaults to \code{TRUE}.}

\item{nboot}{Number of bootstrap samples taken for the method. Ignored if `bootstrap = FALSE`. Defaults to \code{100}.}

\item{ckerorder}{Numeric value specifying kernel order (should be one of
\code{(2,4,6,8)}). Defaults to \code{2}.}

\item{mc.cores}{Number of cores used. Defaults to \code{1}.}
}
\value{
A list of class \code{sobolnp} with the following elements:
\describe{
  \item{\strong{S}}{First order Sobol indices estimated with nonparametric
  regression and a cross-validation bandwidth}
  \item{\strong{bws}}{Bandwidth estimated with cross-validation}
  \item{\strong{Sboot}}{First order Sobol indices estimated with
  nonparametric regression and a bootstrap bandwidth}
  \item{\strong{bwsboot}}{Bandwidth estimated with bootstrap}
}
}
\description{
Algorithm to estimate the Sobol indices using a non-parametric
fit of the regression curve. The bandwidth is estimated using
bootstrap to reduce the finite-sample bias.
}
\examples{
ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}

X <- matrix(runif(3*100, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)

estimation <- sobolnp(Y = Y, X = X, nboot = 5)

}
\references{
Solís, Maikol. "Nonparametric estimation of the first order Sobol indices with bootstrap bandwidth." \emph{arXiv preprint arXiv:1803.03333} (2018).
}
