% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sobolnp.R
\name{print}
\alias{print}
\alias{print.sobolnp}
\title{Print method for objects \code{sobolnp}}
\usage{
print(snp, ...)

\method{print}{sobolnp}(snp, ...)
}
\arguments{
\item{snp}{an object of class \code{sobolnp}}

\item{...}{further arguments passed to the \code{print} function}
}
\value{
A formatted table with the results of the \code{\link{sobolnp}}
function.
}
\description{
Print method for objects \code{sobolnp}
}
\examples{

ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}

X <- matrix(runif(3*100, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)

estimation <- sobolnp(Y = Y, X = X, nboot = 5)

print(estimation)

}
