% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.regression.R
\name{fit.ridge}
\alias{fit.ridge}
\title{Fit Ridge Regression with Closed-Form Solution}
\usage{
fit.ridge(x, y, lambda)
}
\arguments{
\item{x}{A standardized design matrix (n × p)}

\item{y}{A centered response vector (n × 1)}

\item{lambda}{A non-negative regularization scalar}
}
\value{
A list containing:
\describe{
  \item{coefficients}{Ridge regression coefficients (length p)}
  \item{std_errors}{Standard errors of the coefficients (length p)}
}
}
\description{
Computes ridge regression coefficients and standard errors using the closed-form solution:
\eqn{\hat{\beta} = (X^T X + \lambda I)^{-1} X^T y}
}
\keyword{internal}
