% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_panel_label.R
\name{sm_panel_label}
\alias{sm_panel_label}
\title{Writing a label for each panel of a combined figure}
\usage{
sm_panel_label(
  all_plots,
  x,
  y,
  panel_tag = "1",
  panel_pretag,
  panel_posttag,
  text_size = 5.5,
  text_color = "black",
  fontface = "plain",
  ...
)
}
\arguments{
\item{all_plots}{all_plots should be a list vector, which should contain all panels
that are to be combined into one figure.}

\item{x}{Location of the label along the x-axis (0 to 1). 0.5 is the middle origin.}

\item{y}{Location of the label along the y-axis (0 to 1). 0.5 is the middle origin.}

\item{panel_tag}{A character vector that defines how each panel is enumerated. Options include:
'a', 'A', '1', 'I' or 'i'.'a' is for lowercase letters. 'A' is for uppercase letters. '1'
is for integers. 'I' is for upper case roman numerals. 'i' is for lower case roman numerals.
Each panel will display a unique string based on the set enumeration.}

\item{panel_pretag}{A character vector that is identical across panels BEFORE the panel_tag.}

\item{panel_posttag}{A character vector that is identical across panels AFTER the panel_tag.}

\item{text_size}{Text size of the panel label}

\item{text_color}{Text color of the panel label}

\item{fontface}{Fontface of the panel label. Options include "plain", "bold", "italic" and others
that are provided by ggplot2.}

\item{...}{Additional parameters for adjusting the appearance of the sticker. Same parameters
for annotate() from ggplot2.}
}
\value{
It returns a list of plots with panel labels.
}
\description{
Writing a label for each panel of a combined figure
}
\examples{
library(ggplot2)
library(smplot2)

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
geom_point(shape = 21, fill = '#0f993d', color = 'white',
          size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
 sm_hvgrid() -> p2

sm_panel_label(list(p1,p2), x = 0.1, y = 0.9,
              panel_tag ='1', panel_pretag = 'S', text_size = 4, text_color = 'black')

}
