% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elfunctions.R
\name{EL}
\alias{EL}
\title{Unified empirical likelihood wrapper}
\usage{
EL(
  z,
  ct = NULL,
  mu = NULL,
  shift = NULL,
  type = c("auto", "EL1", "EL0", "EuL"),
  chull.fail = c("none", "taylor", "wald", "adjusted", "adjusted2", "balanced"),
  renormalise = FALSE,
  return.weights = FALSE,
  weight.tolerance = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{z}{A numeric vector or a matrix with one data vector per column.}

\item{ct}{Numeric count variable with non-negative values that indicates the multiplicity of observations.}

\item{mu}{Hypothesised mean, default \code{(0 ... 0)} in \eqn{R^{\mathrm{ncol}(z)}}{R^ncol(z)}.}

\item{shift}{The value to add in the denominator (useful in case there are extra
Lagrange multipliers): \eqn{1 + \lambda'Z + shift}{1 + lambda'Z + shift}.}

\item{type}{Character: one of \code{c("auto", "EL1", "EL0", "EuL")}. If \code{"auto"},
uses \code{"EL1"} for multi-variate data and \code{"EL0"} for uni-variate.}

\item{chull.fail}{Character: \code{"none"} calls the original EL (which may return
\code{-Inf} in case of a convex-hull violation), \code{"taylor"} calls [ExEL1()],
\code{"wald"} calls [ExEL2()], \code{"adjusted"} adds one pseudo-observation as in
\insertCite{chen2008adjusted}{smoothemplik}, \code{"adjusted2"} adds one (in 1D) or
two (2D+) pseudo-observations with improved coverage rate according to
\insertCite{liu2010adjusted}{smoothemplik}, and \code{"balanced"} adds two
pseudo-observations according to \insertCite{emerson2009calibration}{smoothemplik}.}

\item{renormalise}{If \code{FALSE}, then uses the total sum of counts as the number of observations,
like in vanilla empirical likelihood, due to formula (2.9) in \insertCite{owen2001empirical}{smoothemplik},
otherwise re-normalises the counts to 1 according to \insertCite{cosma2019inference}{smoothemplik}
(p. 170, the topmost formula).}

\item{return.weights}{Logical: if \code{TRUE}, returns the empirical probabilities.
Default is memory-saving (\code{FALSE}).}

\item{weight.tolerance}{Weight tolerance for counts to improve numerical stability
(defaults to \code{sqrt(.Machine$double.eps)} times the maximum weight).}

\item{verbose}{Logical: print output diagnostics?}

\item{...}{Named extra arguments passed to the selected back-end (e.g. \code{order},
\code{itermax}, \code{lambda.init}, \code{vt}, \code{trunc.to}, \code{boundary.tolerance}, ...).}
}
\value{
A list with either the return value of the selected back-end  or (for extrapolation
  methods) at least the \code{logelr} list value and extrapolation attributes.
}
\description{
Call \code{EL0()}, \code{EL1()}, or \code{EuL()} through a single interface.
If extrapolation is requested, switch to dedicated functions.
Anything method-specific goes into \code{EL.args}.
}
\examples{
# EL0 with extras:
EL(type = "EL0", z = 1:9, mu = 4, boundary.tolerance = 1e-8)
# EL1 with a custom order and iteration cap:
set.seed(1)
x <- cbind(rnorm(30), runif(30)-0.5)
EL(type = "EL1", z = x, mu = c(0, 0), order = 4, itermax = 50, return.weights = TRUE)
# EuL with vt and truncation:
set.seed(1)
EL(type = "EuL", z = x, vt = runif(NROW(x)), weight.tolerance = 0.1, trunc.to = 0.1)

# Extrapolated variants
set.seed(1)
EL(type = "EL0", z = 1:9, mu = 12, chull.fail = "taylor", exel.control = list(xlim = c(2, 8)))
EL(type = "EL1", z = 1:9, mu = 12, chull.fail = "wald", exel.control = list(fmax = 10))
x <- matrix(runif(20), ncol = 2)
EL(x, mu = c(0, 0), chull.fail = "adjusted")
EL(x, mu = c(0, 0), chull.fail = "adjusted2")
EL(x, mu = c(0, 0), chull.fail = "balanced")

}
\references{
\insertAllCited{}
}
