% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ladybird}
\alias{ladybird}
\title{Ladybird transmission of fungus}
\format{
A data frame with 8 variables: \code{ID}, \code{Run}, \code{DPlant}, \code{Host}, \code{Ladybird}, \code{Cadaver}, \code{Live}, \code{Infected}.
\describe{
  \item{ID}{Factor. Unique identifier for each experimental container (observation).}
  \item{Run}{Factor. Experimental run (1 or 2), indicating replicate.}
  \item{DPlant}{Factor. Unique identifier for each experimental plant within a run (1–36).}
  \item{Host}{Factor. Type of host plant in the container ("beans" or "trefoil").}
  \item{Ladybird}{Factor. Indicator for presence ("+") or absence ("-") of ladybird foraging in the container.}
  \item{Cadaver}{Integer. Number of sporulating aphid cadavers distributed on each plant (5, 10, or 20).}
  \item{Live}{Integer. Number of live aphids remaining in the container after seven days.}
  \item{Infected}{Integer. Number of live aphids found to be infected after seven days.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
ladybird
}
\description{
An experiment was conducted to study the transmission of fungus from ladybirds to aphids on two host plant types (beans or birdsfoot trefoil). The study used containers, each holding one plant with 20 aphids, and varied the fungal load by distributing 5, 10, or 20 sporulating aphid cadavers per plant. For each host plant and fungal load combination, half of the containers were exposed to ladybird foraging for four hours, and half were not, creating a three-way factorial structure: Host (two levels), Cadaver (three levels), and Ladybird presence (two levels). This setup was blocked in two runs (Run), with six replicates per treatment combination per run, resulting in a total of 72 experimental units. Each unit (DPlant) was randomly assigned treatments, and after seven days, the numbers of live (Live) and infected (Infected) aphids were counted. Due to aphid predation by ladybirds, the number of live aphids varied, so the percentage of infected aphids was used to quantify transmission rates. This dataset enables analysis of the main and interactive effects of host plant, fungal load, and ladybird presence on aphid infection rates.
}
\examples{
summary(aov(log(P / (100 - P)) ~ Host * Cadaver * Ladybird + Error(Run/DPlant),
            data = ladybird |>
              transform(P = 100 * (Infected + 1) / (Live + 2),
                        Cadaver = factor(Cadaver))))

}
\keyword{datasets}
