% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_imp.R
\name{knn_imp}
\alias{knn_imp}
\title{K-Nearest Neighbor Imputation for Numeric Matrices}
\usage{
knn_imp(
  obj,
  k,
  colmax = 0.9,
  method = c("euclidean", "manhattan"),
  cores = 1,
  post_imp = TRUE,
  subset = NULL,
  dist_pow = 0,
  tree = NULL
)
}
\arguments{
\item{obj}{A numeric matrix with \strong{samples in rows} and \strong{features in columns}.}

\item{k}{Number of nearest neighbors for imputation. 10 is a good starting point.}

\item{colmax}{A number from 0 to 1. Threshold of missing data above which K-NN imputation is skipped.}

\item{method}{Either "euclidean" (default) or "manhattan". Distance metric for nearest neighbor calculation.}

\item{cores}{Number of cores to parallelize over.}

\item{post_imp}{Whether to impute remaining missing values (those that failed K-NN imputation)
using column means (default = \code{TRUE}).}

\item{subset}{Character vector of column names or integer vector of column
indices specifying which columns to impute.}

\item{dist_pow}{The amount of penalization for further away nearest neighbors in the weighted average.
\code{dist_pow = 0} (default) is the simple average of the nearest neighbors.}

\item{tree}{Either \code{NULL} (default, brute-force K-NN), "ball", or "kd" to find nearest neighbors using the \code{{mlpack}} ball-tree or kd-tree algorithms.}
}
\value{
A numeric matrix of the same dimensions as \code{obj} with missing values imputed.
}
\description{
Imputes missing values in numeric matrices using full k-nearest neighbor imputation.
}
\details{
This function performs \strong{column-wise} nearest neighbor imputation.

When \code{dist_pow > 0}, imputed values are computed as distance-weighted averages
where weights are inverse distances raised to the power of \code{dist_pow}.

The \code{tree} parameter enables faster neighbor search using spatial data structures
but requires pre-filling missing values with column means, which may introduce bias
in high-missingness data. Tree construction overhead may reduce performance for
low-dimensional data.
}
\section{Performance Optimization}{

\itemize{
\item \strong{Tree methods}: Only use when imputation runtime becomes prohibitive and
missingness is low (<5\% missing)
\item \strong{Subset imputation}: Use \code{subset} parameter for efficiency when only
specific columns need imputation (e.g., epigenetic clocks CpGs)
}
}

\examples{
data(khanmiss1)
sum(is.na(khanmiss1))

# Basic K-NN imputation (khanmiss1 has genes in rows, so transpose)
t_khanmiss1 <- t(khanmiss1)
result <- knn_imp(t_khanmiss1, k = 5)
result

}
\references{
Robert Tibshirani, Trevor Hastie, Balasubramanian Narasimhan, and Gilbert Chu (2002).
Diagnosis of multiple cancer types by shrunken centroids of gene expression
PNAS 99: 6567-6572. Available at www.pnas.org
}
