% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_utilities.R
\name{plot_cor_network}
\alias{plot_cor_network}
\alias{plot_cor_network.default}
\alias{plot_cor_network.simdesign_mvtnorm}
\title{Visualize fixed correlation structure as a network}
\usage{
plot_cor_network(obj, ...)

\method{plot_cor_network}{default}(
  obj,
  categorical_indices = NULL,
  decimals = 2,
  cor_cutoff = 0.1,
  vertex_labels = NULL,
  vertex_label_prefix = "z",
  edge_width_function = function(x) x * 10,
  edge_label_function = function(x) round(x, decimals),
  use_edge_weights = FALSE,
  edge_weight_function = base::identity,
  seed = NULL,
  return_network = FALSE,
  mar = c(0, 0, 0, 0),
  vertex.size = 12,
  margin = 0,
  asp = 0,
  vertex.color = "#ececec",
  vertex.frame.color = "#979797",
  vertex.label.color = "black",
  edge.color = "ramp",
  edge.label.color = "black",
  edge.label.cex = 0.8,
  ...
)

\method{plot_cor_network}{simdesign_mvtnorm}(obj, ...)
}
\arguments{
\item{obj}{Correlation matrix or S3 class object which has a class method available (see below).}

\item{...}{Passed to \code{\link[igraph:plot.igraph]{igraph::plot}}, with a complete list
of arguments and details given in \code{\link[igraph:plot.common]{igraph.plotting}}.}

\item{categorical_indices}{Vector of indices of variables which should be drawn as rectangles
(i.e. represent categorical data).}

\item{decimals}{Number of decimals, used for default labeling of the network edges.}

\item{cor_cutoff}{Threshold of absolute correlation below which nodes are not considered
as connected. Useful to control complexity of drawn network.
Set to NULL to disable.}

\item{vertex_labels}{Character vector of length \code{nrow(obj)} of labels for vertices. If not NULL,
overrides the \code{vertex_label_prefix} argument. If set to NA omits all
or some vertex labels.}

\item{vertex_label_prefix}{String which is added as prefix to node labels.}

\item{edge_width_function}{Function which takes one vector input (absolute correlation values) and
outputs transformation of this vector (must be >= 0). Defines edge widths.}

\item{edge_label_function}{Function which takes on vector input (absolute correlation values) and
outputs labels for these values as character vector. Defines edges labels.
If set to NULL, then no edge labels will be displayed.}

\item{use_edge_weights}{Logical, if TRUE then the layout will be influenced by the absolute
correlations (i.e. edge weights) such that highly correlated variables will
be put closer together.
If FALSE, then the layout is independent of the correlation structure.}

\item{edge_weight_function}{Function which takes one vector input (absolute correlation values) and
outputs transformation of this vector (must be >= 0). Defines edge weights.
Only relevant if \code{use_edge_weights} is TRUE.}

\item{seed}{Set random seed to ensure reproducibility of results. Can be fixed to
obtain same layout but vary edge widths, correlation functions etc. Can
also be used to obtain nicer looking graph layouts.}

\item{return_network}{If TRUE, the \code{igraph} network object is returned and can be plotted by
the user using e.g. the interactive \code{\link[igraph:tkplot]{igraph::tkplot}}
function.}

\item{mar}{\code{mar} argument to the \code{\link[graphics:par]{par}} function to set
margins of the plot (often required when the axes should be drawn).
A numerical vector of the form c(bottom, left, top, right) which gives the
number of lines of margin to be specified on the four sides of the plot.
The default is c(5, 4, 4, 2) + 0.1. Note that this is not the same argument
as the \code{margin} argument for the \code{igraph::plot.igraph} function.}

\item{vertex.size, margin, asp, vertex.frame.color, vertex.label.color, edge.label.color, edge.label.cex}{Arguments to \code{\link[igraph:plot.igraph]{igraph::plot}}, with sensible
defaults for this package's usage.}

\item{vertex.color}{Argument passed to \code{\link[igraph:plot.igraph]{igraph::plot}}. Usually a
character vector with a hex color specification for vertex color.
Alternatively a function that takes as input a data.frame with a column "id"
that gives the column number of the simulated data, and outputs a valid color
specification for the corresponding vertices (i.e. a single character hex
color or a vector of such hex colors of appropriate length).}

\item{edge.color}{Argument passed to \code{\link[igraph:plot.igraph]{igraph::plot}}. This
package implements some special functionality: if \code{edge.color = "ramp"} then
a colorramp from red (-1) via white (0) to blue (1) is mapped to the
correlations and the edges colored accordingly.
If \code{edge.color = "clipped-ramp"} then the ramp is restricted to the
correlation values observed, which may be useful if they are low to increase
visibility.
If \code{edge.color = "red-blue"} then all edges with positive correlation values
are colored uniformly red, and all edges with negative correlations are
colored uniformly blue. Alternatively, may be a function that takes as
input the edge correlation values and outputs valid color specifications
(i.e. a single hex color or a vector of hex colors of appropriate length).}
}
\value{
If \code{return_network} is \code{TRUE}, then an \code{igraph} network object is returned
that can be plotted by the user using e.g. the interactive
\code{\link[igraph:tkplot]{igraph::tkplot}} function. Otherwise, the network
object is plotted directly and no output is returned.
}
\description{
Useful to visualize e.g. the associations of the initial multivariate
gaussian distribution used by \code{\link{simdesign_mvtnorm}}.
}
\details{
For an explanation of all parameters not listed here, please refer to
\code{\link[igraph:plot.igraph]{igraph::plot}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{plot_cor_network(default)}: Function to be used for correlation matrix.

\item \code{plot_cor_network(simdesign_mvtnorm)}: Function to be used with \code{\link{simdesign_mvtnorm}}
S3 class object to visualize initial correlation network of the underlying
multivariate normal distribution.

}}
\seealso{
\code{\link{plot_cor_network.simdesign_mvtnorm}},
\code{\link{plot_estimated_cor_network}}
}
