% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boin_decision.R
\name{get_boin_decision}
\alias{get_boin_decision}
\title{Generate Dose Decision Table for BOIN Design}
\usage{
get_boin_decision(target, lambda_e, lambda_d, max_sample_size, cutoff_eli)
}
\arguments{
\item{target}{Numeric. The target toxicity probability (e.g., 0.30 for 30\%).}

\item{lambda_e}{Numeric. Escalation boundary from \code{get_boin_boundary()}.
Doses with observed toxicity rate <= lambda_e trigger escalation.}

\item{lambda_d}{Numeric. De-escalation boundary from \code{get_boin_boundary()}.
Doses with observed toxicity rate >= lambda_d trigger de-escalation.}

\item{max_sample_size}{Numeric. Maximum sample size (number of patients) for table columns.
Typically 18-30 for phase I trials.}

\item{cutoff_eli}{Numeric. Cutoff probability for dose elimination. Default is 0.95.
If Pr(p > target | data) > cutoff_eli, dose is marked for elimination.}
}
\value{
A character matrix with dose decisions:
\itemize{
\item Rows represent cumulative number of DLTs (0 to max_sample_size)
\item Columns represent cumulative number of patients (1 to max_sample_size)
\item Cell values are decisions: "E" (Escalate), "D" (De-escalate),
"DE" (De-escalate & Eliminate), "S" (Stay), or NA (logically impossible)
}
}
\description{
Create a pre-computed lookup table that maps (number of DLTs, number of patients)
pairs to dose decisions (Escalate, De-escalate, Stay, or Eliminate). This table
is generated once before the trial and consulted repeatedly during dose assignment.
}
\details{
Decision rules applied in order:
\enumerate{
\item Rule DE: If n >= 3 and Pr(p > target | data) > cutoff_eli, eliminate dose
\item Rule E: If observed toxicity rate <= lambda_e, escalate
\item Rule D: If observed toxicity rate >= lambda_d, de-escalate
\item Rule S: Otherwise, stay at current dose
}

The posterior probability Pr(p > target | data) is computed using Beta-Binomial
conjugate prior with uniform prior (Beta(1,1)).
}
\examples{
# Generate decision table for 30\% target toxicity rate
boin_bound <- get_boin_boundary(target = 0.30)
DECISION <- get_boin_decision(
  target = 0.30,
  lambda_e = boin_bound$lambda_e,
  lambda_d = boin_bound$lambda_d,
  max_sample_size = 18,
  cutoff_eli = 0.95
)
print(DECISION)

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
