% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-funs.R
\name{silv_sample_size}
\alias{silv_sample_size}
\title{Calculates sample size for a random sampling inventory}
\usage{
silv_sample_size(
  x,
  plot_size,
  total_area,
  method = "random",
  max_error = 0.05,
  conf_level = 0.95,
  max_iter = 1000,
  quiet = FALSE
)
}
\arguments{
\item{x}{vector of field survey}

\item{plot_size}{a numeric vector of length one with plot size in squared meters}

\item{total_area}{total area of the study area in squared meters}

\item{method}{sampling method. Available options are \code{random}}

\item{max_error}{maximum allowed error}

\item{conf_level}{confidence level}

\item{max_iter}{maximum number of iteration to find the plot size}

\item{quiet}{if \code{TRUE}, messages will be supressed}
}
\value{
SampleSize object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
## pilot inventory measuring 4 plots of 25x25 meters
## total forest area 15 ha
## measured variable (x): basal area per hectare
silv_sample_size(
  x          = c(33, 37.5, 42, 35.2),
  plot_size  = 25 * 25,  # squared plot of 25x25
  total_area = 15 * 1e4, # 15 ha
  max_error  = 0.05,
  conf_level = 0.95,
  max_iter   = 100
)
}
