% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkem_main_functions.R
\name{F}
\alias{F}
\alias{dF}
\alias{rF}
\title{The (scaled) F Distribution}
\usage{
dF(x, df1, df2, beta, log = FALSE)

rF(n, df1, df2, beta)
}
\arguments{
\item{x}{vector of quantities.}

\item{df1}{First degrees of freedom}

\item{df2}{Second degrees of freedom}

\item{beta}{Scale parameter}

\item{log}{logical; if TRUE, density is given as log(p).}

\item{n}{number of draws}
}
\value{
\code{dF} gives the probability density of the F distribution. \code{rF} gives random draws from the F distribution.
}
\description{
Density and random generation for the F distribution with first degrees of freedom \code{df1},
second degrees of freedom \code{df2}, and scale parameter \code{beta}.
}
\examples{

draws_F <- rF(n=1e4, df1=2, df2=4, beta=1)
hist(draws_F,500,xlim=c(0,10),freq=FALSE)
seqx <- seq(0,10,length=1e5)
lines(seqx,dF(seqx, df1=2, df2=4, beta=1),col=2,lwd=2)

}
\references{
Mulder and Pericchi (2018). The Matrix-F Prior for Estimating and Testing Covariance Matrices.
Bayesian Analysis, 13(4), 1193-1214. <https://doi.org/10.1214/17-BA1092>
}
