% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq.R
\name{seq.jdatetime}
\alias{seq.jdatetime}
\title{Generate regular sequences of Jalali date-times}
\usage{
\method{seq}{jdatetime}(from, to, by, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{starting date; optional.}

\item{to}{end date; optional.}

\item{by}{increment of the sequence; optional.  See \sQuote{Details}.}

\item{length.out}{integer, optional.  Desired length of the sequence.}

\item{along.with}{take the length from the length of this argument.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A vector of \code{jdatetime} objects.
}
\description{
The method for \link{seq} for objects of class \code{jdatetime}.
}
\details{
\code{by} can be specified in several ways:
\itemize{
\item A number, taken to be in seconds.
\item A object of class \link{difftime}.
\item A character string, containing one of "sec", "min", "hour", "day", "DSTday",
"week", "month", "quarter" or "year".
This can optionally be preceded by a (positive or negative) integer
and a space, or followed by "s".
}
}
\examples{
# first days of years
seq(jdatetime_make(1390, 1, 1), jdatetime_make(1399, 1, 1), "years")
# by month
seq(jdatetime_make(1400, 1, 1), by = "month", length.out = 12)
seq(jdatetime_make(1400, 1, 31), by = "month", length.out = 12)
# days vs DSTdays
seq(jdatetime_make(1400, 1, 1, 12, tzone = "Asia/Tehran"), by = "day", length.out = 2)
seq(jdatetime_make(1400, 1, 1, 12, tzone = "Asia/Tehran"), by = "DSTday", length.out = 2)
seq(jdatetime_make(1400, 1, 1, 12, tzone = "Asia/Tehran"), by = "1 week", length.out = 2)
seq(jdatetime_make(1400, 1, 1, 12, tzone = "Asia/Tehran"), by = "7 DSTdays", length.out = 2)
}
\seealso{
\code{\link[base:seq.POSIXt]{base::seq.POSIXt()}}
}
