% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_timeseries_scatterplot.R
\name{draw_timeseries_scatterplot}
\alias{draw_timeseries_scatterplot}
\title{Draw Timeseries Scatterplot}
\usage{
draw_timeseries_scatterplot(
  data,
  y_var,
  grouping_var_1,
  grouping_var_1_type = "date-time",
  grouping_var_2,
  faceting = FALSE,
  limits = FALSE,
  date_breaks = "1 month",
  date_labels = "\%b \%y",
  analysis_desc_label = NULL,
  x_axis_text_size = 11,
  point_size = 1,
  alpha = 0.3,
  line_size = 1,
  interactive = TRUE
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{y_var}{Y variable to be plotted on Y axis (required)}

\item{grouping_var_1}{Time variable to be plotted on x axis (required)}

\item{grouping_var_1_type}{Time variable type. Options are "date-time" or "factor"}

\item{grouping_var_2}{Additional variable for faceting (optional)}

\item{faceting}{Set whether to display each group in a separate plot. By default, it is set to FALSE (optional)}

\item{limits}{Logical. If TRUE, process behavior chart control limits for the individual group means are plotted. By default, it is set to FALSE  (optional)}

\item{date_breaks}{Set date breaks. Takes a string, for example "1 week" or "2 days". By default, it is set to "1 month" (optional)}

\item{date_labels}{Set date labels. Identical to the date labels argument of the scale_x_date() ggplot function (optional)}

\item{analysis_desc_label}{Label (subtitle) for analysis description. By default, it is set to NULL  (optional)}

\item{x_axis_text_size}{X axis text size. By default, it is set to 11. (optional)}

\item{point_size}{Set point size. By default, it is set to 1  (optional)}

\item{alpha}{Set transparency for individual observations. Identical to the alpha ggplot argument. By default, it is set to 0.3 (optional)}

\item{line_size}{Set line size. By default, it is set to 1  (optional)}

\item{interactive}{Set plot interactivity. By default, it is set to TRUE (optional)}
}
\value{
A 'ggplot' or 'plotly' object
}
\description{
Draws a Timeseries Scatterplot
}
\examples{
timeseries_scatterplot_data \%>\%
   draw_timeseries_scatterplot(y_var = y,
                               grouping_var_1 = date,
                               grouping_var_2 = cavity,
                               faceting       = TRUE,
                               limits         = TRUE,
                               alpha          = 0.15,
                               line_size      = 0.5,
                               x_axis_text    = 7,
                               interactive    = FALSE)

}
