% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Square}
\alias{Square}
\title{Adjacency from bipartite}
\usage{
Square(x)
}
\arguments{
\item{x}{matrix encoding the edges between two types of nodes (rows and
columns).}
}
\value{
A symmetric adjacency matrix encoding a bipartite graph.
}
\description{
Generates a symmetric adjacency matrix encoding a bipartite graph.
}
\examples{
# Simulated links between two sets
set.seed(1)
mat <- matrix(sample(c(0, 1), size = 15, replace = TRUE),
  nrow = 5, ncol = 3
)

# Adjacency matrix of a bipartite graph
Square(mat)
}
