% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic-templates.R
\name{dynamic_template}
\alias{dynamic_template}
\title{Add dynamic template}
\usage{
dynamic_template(sg_mail, template_id, template_data, force = FALSE)
}
\arguments{
\item{sg_mail}{(required) mail object from package}

\item{template_id}{(required) template_id start "d-" and 32-length only digit and lower case alphabet like "d-4ad23ad40a0e47d0a0232b85f24ca5c2"}

\item{template_data}{A key-value list for template data. (See \url{https://docs.sendgrid.com/ui/sending-email/how-to-send-an-email-with-dynamic-templates})}

\item{force}{pass template_id validation. default is FALSE.}
}
\value{
sg_mail class with dynamic template
}
\description{
Create dynamic templates at \url{https://mc.sendgrid.com/dynamic-templates}.
}
\examples{
mail() \%>\%
  dynamic_template("d-4ad23ad40a0e47d0a0232b85f24ca5c2", list(first_name = "Amanda", link = "foo"))

mail() \%>\%
  dynamic_template(template_id = "foo",
    template_data = list(first_name = "Amanda", link = "foo"),
    force = TRUE)
}
