% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu_item.R
\name{sidebar_menu}
\alias{sidebar_menu}
\alias{sidebarMenu}
\title{Create a sidebar menu.}
\usage{
sidebar_menu(..., id = "uisidebar")

sidebarMenu(..., id = "uisidebar")
}
\arguments{
\item{...}{Menu items.}

\item{id}{The sidebar id class also used for update input on server side. Default is \code{uisidebar}}
}
\value{
A sidebar menu that can be passed \code{\link[semantic.dashboard]{dashboardSidebar}}
}
\description{
Create a sidebar menu with menu items.
}
\details{
It's possible to set selected menu item by setting `selected = TRUE` in `menuItem`.
}
\section{Functions}{
\itemize{
\item \code{sidebarMenu}: Create a sidebar menu (alias for \code{sidebar_menu} for compatibility with \code{shinydashboard})
}}

\examples{
sidebarMenu(
  menuItem(tabName = "plot_tab", text = "My plot", icon = icon("home")),
  menuItem(tabName = "table_tab", text = "My table", icon = icon("smile"), selected = TRUE)
  )
}
