% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{offspring_gf_3}
\alias{offspring_gf_3}
\title{Calculates offspring genotype frequencies under the three-parameter model.}
\usage{
offspring_gf_3(tau, beta, gamma1, gamma2 = gamma1, p1, p2)
}
\arguments{
\item{tau}{Probability of quadrivalent formation}

\item{beta}{Probability of double reduction given quadrivalent formation}

\item{gamma1}{Probability of AA_aa pairing in parent 1}

\item{gamma2}{Probability of AA_aa pairing in parent 2}

\item{p1}{The first parent's genotype}

\item{p2}{The second parent's genotype}
}
\value{
Offspring genotype frequencies
}
\description{
Calculates offspring genotype frequencies under the three-parameter model.
}
\examples{
offspring_gf_3(
  tau = 1/2,
  beta = 1/6,
  gamma1 = 1/3,
  gamma2 = 1/3,
  p1 = 1,
  p2 = 2)

}
\author{
David Gerard
}
