% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{calc_efficiency}
\alias{calc_efficiency}
\title{Calculate Search Efficiency Metrics}
\usage{
calc_efficiency(search_time, results_count, relevant_count)
}
\arguments{
\item{search_time}{Time taken to execute search (in seconds)}

\item{results_count}{Number of results retrieved}

\item{relevant_count}{Number of relevant results}
}
\value{
List containing efficiency metrics
}
\description{
Calculate Search Efficiency Metrics
}
\details{
Calculates various efficiency metrics for search performance:
\itemize{
\item \strong{time_per_result}: Average time to retrieve each result
\item \strong{time_per_relevant}: Average time to retrieve each relevant result
\item \strong{relevant_ratio}: Proportion of results that are relevant
\item \strong{efficiency_score}: Overall efficiency combining time and relevance
}
}
\examples{
efficiency <- calc_efficiency(search_time = 30, results_count = 100, relevant_count = 15)
print(paste("Efficiency score:", round(efficiency$efficiency_score, 4)))
}
