% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aetoxgr.R
\name{check_ae_aetoxgr}
\alias{check_ae_aetoxgr}
\title{Check for missing AETOXGR and/or AESEV values}
\usage{
check_ae_aetoxgr(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AESTDTC,
AEDECOD, AETERM, and AETOXGR (or AESEV)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing AETOXGR and/or AESEV values and
returns a data frame. If both variables exist it returns records where both
are missing.
}
\examples{
# test with sample data


AE <- data.frame(
 USUBJID = 1:3,
 DOMAIN = c(rep("AE", 3)),
 AESEQ = 1:3,
 AESTDTC = 1:3,
 AETERM = c("FLU COUGH", "HEADACHE", "FEVER"),
 AEDECOD = c("", "Headache", "Fever"),
 AETOXGR = 1:3,
 AESEV = 1:3,
 AESPID = "FORMNAME-R:16/L:16XXXX",
 stringsAsFactors = FALSE
)

check_ae_aetoxgr(AE)

AE$AETOXGR[1] <- NA
check_ae_aetoxgr(AE)

AE$AESEV[1] <- NA
check_ae_aetoxgr(AE,preproc=roche_derive_rave_row)

AE$AETOXGR <- NULL
check_ae_aetoxgr(AE,preproc=roche_derive_rave_row)

AE$AESPID <- NULL
check_ae_aetoxgr(AE,preproc=roche_derive_rave_row)

AE$AESEV <- NULL
check_ae_aetoxgr(AE)

AE$AEDECOD <- NULL
check_ae_aetoxgr(AE)


}
\author{
Will Harris, Stella Banjo (HackR 2021)
}
