% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_all}
\alias{plot_all}
\title{Generate all plots for SCM analysis}
\usage{
plot_all(
  result,
  start_year = NULL,
  unit_name = "Treated Unit",
  outcome_label = "Outcome",
  treatment_label = "Treatment",
  show_ci = TRUE
)
}
\arguments{
\item{result}{Output from run_scm_spillover}

\item{start_year}{First year of treatment period}

\item{unit_name}{Name of treated unit (default "Treated Unit")}

\item{outcome_label}{Label for outcome variable (default "Outcome")}

\item{treatment_label}{Label for treatment (default "Treatment")}

\item{show_ci}{Logical, whether to show confidence bands (default TRUE)}
}
\value{
A list containing three ggplot objects (p1, p2, p3), returned
  invisibly. Called primarily for side effects (displaying plots).
}
\description{
Generate all plots for SCM analysis
}
\examples{
\dontrun{
  data <- generate_test_data()
  result <- run_scm_spillover(data, treatment_start = 20)
  plots <- plot_all(result)
}
}
