% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_model_analysis.R
\name{mixed_model_analysis}
\alias{mixed_model_analysis}
\title{Mixed Model Analysis}
\usage{
mixed_model_analysis(
  .df,
  .dv,
  .time,
  .phase,
  .participant = NULL,
  rev_time_in_phase = FALSE,
  phase_levels = NULL,
  phase_labels = NULL,
  covs = NULL,
  ...
)
}
\arguments{
\item{.df}{A data frame containing the dataset to be analyzed.}

\item{.dv}{The name of the dependent variable in the dataset.}

\item{.time}{The name of the time variable in the dataset.}

\item{.phase}{The name of the phase variable in the dataset.}

\item{.participant}{(optional) The name of the participant identifier variable
in the dataset. If not provided, a default factor will be used.}

\item{rev_time_in_phase}{(optional) A boolean indicating whether to reverse
the timing within each phase. Defaults to FALSE.}

\item{phase_levels}{(optional) A vector of phase levels to be used for the phase
variable. If NULL, the unique values in the phase variable will be used.}

\item{phase_labels}{(optional) A vector of labels corresponding to the phase_levels.
If NULL, phase_levels will be used as labels.}

\item{covs}{(optional) A vector of names of covariates to be added to the
fixed effect model.}

\item{...}{Additional arguments passed to the \code{gls} function.}
}
\value{
A list containing three elements:
- \code{data}: The modified dataset with added time variables and predicted
values.
- \code{fitted_mod}: The fitted model object from \code{nlme::gls}.
- \code{plot}: A ggplot object showing the predicted values and phase
annotations.
}
\description{
Performs a mixed model analysis on a dataset, allowing for the specification
of a dependent variable, time variable, phase variable, participant
identification, and covariates. It supports reverse timing within phases,
custom phase levels and labels, and adds covariates to the fixed effects model.
The function fits a model using generalized least squares and returns
a list containing the modified dataset, the fitted model, and a plot of
predicted values with phase annotations.
}
\examples{
res <- mixed_model_analysis(efficacy_of_CBT, .dv = "Anxious", .time = "time",
                            .phase = "phase",rev_time_in_phase = TRUE,
                            phase_levels = c(0, 1),
                            phase_labels = c("Exposure", "Exposure + CT"))

summary(res$fitted_mod)

}
\references{
Maric, M., & van der Werff, V. (2020). Single-Case Experimental
Designs in Clinical Intervention Research. In R. van de Schoot & M. Miocevic
(Eds.), Small Sample Size Solutions: A Guide for Applied Researchers and
Practitioners (1st ed., pp. 10). Routledge.
\url{doi:10.4324/9780429273872-9}
}
