% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_max.R
\name{s_max}
\alias{s_max}
\title{Calculate Maximum Number of Shards}
\usage{
s_max(
  R,
  N,
  Data,
  s = 3,
  ep_squaremax = 0.001,
  ncomp = 1,
  Bpercent = 0.5,
  iterations = 10,
  keep = 1,
  npoints = 1000
)
}
\arguments{
\item{R}{(integer) - Number of MCMC draws.}

\item{N}{(integer) - The number of observational units in the full dataset.}

\item{Data}{(list) - A list of lists where each sublist contains either 'regdata' or 'lgtdata'.}

\item{s}{(integer) - A small number of shards used to evaluate the distributed algorithm.}

\item{ep_squaremax}{(numeric) - A value indicating the user's maximum expected error tolerance.}

\item{ncomp}{(integer) - The number of components in the mixture.}

\item{Bpercent}{(numeric) - A decimal value representing the proportion of draws to burn-in}

\item{iterations}{(numeric) - The number of times to estimate the maximum number of shards}

\item{keep}{(numeric) - MCMC thinning parameter -- keep every \code{keep}th draw (default: 1)}

\item{npoints}{(integer) - The number of points at which to evaluate the difference in posterior distributions}
}
\value{
The function returns a list of: (1) A vector of s_max estimated for each iteration, (2) s_max_min calculated using C_0_min,
(3) epsilon_square, (4) ep_squaremax, (5) R, (6) N, (7) Np, (8) C_0, and (9) C_0_min
}
\description{
A function to calculate the maximum number of shards to be used in distributed hierarchical Bayesian algorithm for scalable target marketing.
}
\examples{

\donttest{
# Generate hierarchical linear data
R = 1000
N = 2000
nobs = 5 #number of observations
nvar = 3 #columns
nz = 2

Z = matrix(runif(N*nz),ncol=nz) 
Z = t(t(Z)-apply(Z,2,mean))
Delta = matrix(c(1,-1,2,0,1,0), ncol = nz) 
tau0 = 0.1
iota = c(rep(1,nobs)) 
tcomps=NULL
a = diag(1, nrow=3)
tcomps[[1]] = list(mu=c(-5,0,0),rooti=a) 
tcomps[[2]] = list(mu=c(5, -5, 2),rooti=a)
tcomps[[3]] = list(mu=c(5,5,-2),rooti=a)
tpvec = c(.33,.33,.34)                               
ncomp=length(tcomps)
regdata=NULL
betas=matrix(double(N*nvar),ncol=nvar) 
tind=double(N) 
for (reg in 1:N) { 
 tempout=bayesm::rmixture(1,tpvec,tcomps)
 if (is.null(Z)){
   betas[reg,]= as.vector(tempout$x)  
 }else{
   betas[reg,]=Delta\%*\%Z[reg,]+as.vector(tempout$x)} 
 tind[reg]=tempout$z
 X=cbind(iota,matrix(runif(nobs*(nvar-1)),ncol=(nvar-1))) 
 tau=tau0*runif(1,min=0.5,max=1) 
 y=X\%*\%betas[reg,]+sqrt(tau)*rnorm(nobs)
 regdata[[reg]]=list(y=y,X=X,beta=betas[reg,],tau=tau) 
}

Prior1=list(ncomp=ncomp) 
keep=1
Mcmc1=list(R=R,keep=keep)
Data1=list(list(regdata=regdata,Z=Z))
returns = s_max(R = R, N = N, Data = Data1, s = 1, iterations = 2)
returns
}
}
\references{
Bumbaca, F. (Rico), Misra, S., & Rossi, P. E. (2020). Scalable Target Marketing: Distributed Markov Chain Monte Carlo for Bayesian Hierarchical Models. Journal of Marketing Research, 57(6), 999-1018.
}
\author{
Federico Bumbaca, Leeds School of Business, University of Colorado Boulder, \email{federico.bumbaca@colorado.edu}
}
