% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop-isolates.R, R/breaks.R, R/tab.R
\name{chop_spikes}
\alias{chop_spikes}
\alias{brk_spikes}
\alias{tab_spikes}
\title{Chop common values into singleton intervals}
\usage{
chop_spikes(x, breaks, ..., n = NULL, prop = NULL)

brk_spikes(breaks, n = NULL, prop = NULL)

tab_spikes(x, breaks, ..., n = NULL, prop = NULL)
}
\arguments{
\item{x}{A vector.}

\item{breaks}{A numeric vector of cut-points or a call to a \verb{brk_*} function.
The resulting \code{\link[=breaks-class]{breaks}} object will be modified to add
singleton breaks.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{n, prop}{Scalar. Provide either \code{n}, a number of values, or \code{prop},
a proportion of \code{length(x)}. Values of \code{x} which occur at least this
often will get their own singleton break.}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_spikes()} lets you chop common values of \code{x} into their own
singleton intervals. This can help make unusual values visible.
}
\details{
This function is \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}.
}
\examples{
x <- c(1:4, rep(5, 5), 6:10)
chop_spikes(x, c(2, 7), n = 5)
chop_spikes(x, c(2, 7), prop = 0.25)
chop_spikes(x, brk_width(5), n = 5)

set.seed(42)
x <- runif(40, 0, 10)
x <- sample(x, 200, replace = TRUE)
tab_spikes(x, brk_width(2, 0), prop = 0.05)
}
\seealso{
\code{\link[=dissect]{dissect()}} for a different approach.

Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
