% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sampbias.R
\name{summary.sampbias}
\alias{summary.sampbias}
\title{Summary Method for Class sampbias}
\usage{
\method{summary}{sampbias}(object, ...)
}
\arguments{
\item{object}{An object of the class \code{sampbias}}

\item{\dots}{Additional arguments passed to summary.}
}
\value{
Summary printed to screen.
}
\description{
Summary method for objects of the class \code{sampbias}.
}
\examples{

\donttest{
  #simulate data
  occ <- data.frame(species = rep(sample(x = LETTERS, size = 5), times = 10),
                   decimalLongitude = runif(n = 50, min = 12, max = 20),
                   decimalLatitude = runif(n = 50, min = -4, max = 4))

  out <- calculate_bias(x = occ, terrestrial = TRUE)
  summary(out)
}
}
\seealso{
\code{\link{calculate_bias}} \code{\link{is.sampbias}}
\code{\link{plot.sampbias}}
}
\keyword{methods}
