% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{Hatchery-class}
\alias{Hatchery-class}
\title{Class \code{"Hatchery"}}
\description{
The component of the operating model that controls the hatchery management.
}
\details{
Various parameters can be stochastic (length \code{nsim}) or input as a single numeric
(value identical across all simulations).

A description of the fitness parameters and hatchery dynamics is available in the
\href{https://docs.salmonmse.com/articles/equations.html#hatchery-production}{online documentation}.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{n_r}}{Integer. Number of release strategies, sub-groups of fish with different survival schedules. Default is one.}

\item{\code{n_yearling}}{Vector length \code{n_r}. The target number of yearlings released by release strategy. No hatchery is modeled if \code{sum(n_yearling, n_subyearling) = 0}.
are zero. Yearlings survival is density-independent after release. Default is zero.}

\item{\code{n_subyearling}}{Vector length \code{n_r}. The target number of subyearlings released. No hatchery is modeled if \code{sum(n_yearling, n_subyearling) = 0} are zero.
Subyearlings experience density-dependent survival in competition with natural origin young. Default is zero.}

\item{\code{s_prespawn}}{Numeric. The survival of broodtake prior to egg production. \code{1 - s_prespawn} is the proportion of fish not used for hatchery purposes, e.g., mortality or other resesarch purposes.
Used to back-calculate the broodtake from \code{n_yearling} and \code{n_subyearling}. Default is 1.}

\item{\code{s_egg_smolt}}{Numeric. The survival of eggs to the smolt life stage (for yearling release).
Used to back-calculate the broodtake from \code{n_yearling} and \code{n_subyearling}. Default is 1.}

\item{\code{s_egg_subyearling}}{Numeric. The survival of eggs to subyearling life stage (for subyearling release).
Used to back-calculate the broodtake from \code{n_yearling} and \code{n_subyearling}. Default is 1.}

\item{\code{Mjuv_HOS}}{Either vector by age (length \code{maxage}) or an array with dimension \verb{[nsim, maxage, nyears+proyears, n_r]}.
Natural mortality of immature hatchery origin fish.
To replicate the SAR parameter of a stage-specific model, set \code{Mjuv_HOS[a] = -log(SAR)} for the age class prior to maturation (and zero for all other ages).}

\item{\code{p_mature_HOS}}{Vector by age (length \code{maxage}) or an array with dimension \verb{[nsim, maxage, nyears+proyears, n_r]} for the maturity of hatchery spawners.
Default is set equal to \code{Bio@p_mature} for all release strategies.}

\item{\code{stray_external}}{Matrix by age (length \code{maxage}) and release strategy \code{n_r} that denotes the annual number of hatchery origin strays from other populations/systems
not included in the operating model. Default is zero. External strays are added at the escapement life stage, assumed unmarked. For multi-population models with straying within the system, see also \code{SOM@stray} matrix.}

\item{\code{gamma}}{Numeric. The relative reproductive success of hatchery origin spawners (relative to natural origin spawners). Default is 1.}

\item{\code{m}}{Numeric. The mark rate of hatchery origin fish, which affects selective broodtake and fishery retention if mark-selective fishing is utilized.
Set m = 1 for AHA compatibility with \code{ptarget_NOB}. Default is zero.}

\item{\code{f_brood}}{Function that calculates the natural origin brood and hatchery origin brood from the escapement (after en-route mortality). Function should be of the form
\code{function(NO, HO, stray, m) {return(list(NOB, HOB_marked, HOB_unmarked, HOB_stray))}}. Allows for bespoke rules for broodtake.}

\item{\code{brood_import}}{\strong{Not used if \code{f_brood} is provided} Matrix by age (length \code{maxage}) for the number of annual imported hatchery origin broodstock. Egg production is weighted by \code{fec_brood}.
To meet hatchery production target releases, imported brood and local marked brood are used indiscriminately. Default imported brood is zero.}

\item{\code{pmax_esc}}{\strong{Not used if \code{f_brood} is provided} Numeric. The maximum proportion of total escapement (after en route mortality) that could be used as broodtake. Set to 1 for AHA compatibility. Default is 0.75.}

\item{\code{pmax_NOB}}{\strong{Not used if \code{f_brood} is provided} Numeric. The maximum proportion of the natural origin escapement (after en route mortality and \code{pmax_esc}) to be used as broodtake. If broodstock
is limited by \code{pmax_esc < 1}, then this parameter should be 1. Default is 1.}

\item{\code{ptarget_NOB}}{\strong{Not used if \code{f_brood} is provided} Numeric. The target proportion of the natural origin broodtake relative to the overall broodtake, assuming the mark rate is 1 and natural origin fish
can be identified in the hatchery. The realized proportion may be lower if there are insufficient natural origin escapement. If the mark rate < 1, then
this target proportion identifies the proportion of unmarked fished in the broodtake. If mark rate = 0, then pNOB is equal to the proportion in the escapement. Default is 0.9.}

\item{\code{phatchery}}{\strong{Not used if \code{f_brood} is provided} Numeric. Optional parameter (default is \code{NA}). If set to a numeric between 0-1, this value is the proportion of the hatchery origin escapement that return to the hatchery, for example, by removal from spawning grounds
or swim-in facilities. These fish are available for broodtake. None of these fish will spawn in the natural environment.
With the default option, \code{NA} allows all hatchery origin escapement that is not used brood to go to the spawning grounds.}

\item{\code{premove_HOS}}{Numeric or function. The target proportion of the hatchery origin escapement to be removed from the spawning grounds (in order to
ensure a high proportion of NOS). The proportion of hatchery spawners removed is discounted by the mark rate, i.e., \code{p = premove_HOS * m}.
The removed hatchery origin fish do not spawn and are not available for broodtake. A value less than one can represent
imperfect implementation of weir removal. Default is zero. This can also be a function that returns the proportion based on hatchery and natural escapement (after brood removal),
Allows for bespoke rules for harvest. The function should be of the form: \code{function(NO, HO, m) {return(p)}}.}

\item{\code{fec_brood}}{Vector of length \code{maxage} or an array with dimension \verb{[nsim, maxage, nyears+proyears]}. The fecundity schedule of broodtake to calculate the total egg production for the hatchery. If missing, uses \code{Bio@fec}.}

\item{\code{fitness_type}}{Character vector length 2. The fitness function to apply in the natural and hatchery environment, respectively. For each, either "Ford" or "none".}

\item{\code{theta}}{Vector length 2. The optimum phenotype value for the natural and hatchery environments.}

\item{\code{rel_loss}}{Vector length 3. The loss in fitness apportioned among the egg, fry, and smolt life stages which reduces survival. Theoretically, the three values should sum to 1. Alternatively,
set to zero to set fitness loss to zero for that specific life stage (survival is one).}

\item{\code{zbar_start}}{Vector length 2. The mean phenotype value in the natural and hatchery populations at the start of the projection. Alternatively,
an array by dimension \verb{[nsim, maxage, 2]}, where the age slot corresponds to cohort.}

\item{\code{fitness_variance}}{Numeric. The variance (omega-squared) of the fitness function. Assumed identical between the natural and hatchery environments. Default is 100.}

\item{\code{phenotype_variance}}{Numeric. The variance (sigma-squared) of the phenotypic trait (theta). Assumed identical between the natural and hatchery environments. Default is 10.}

\item{\code{heritability}}{Numeric or vector length \verb{[nsim]}. The heritability (h-squared) of the phenotypic trait. Between 0-1. Default is 0.5}

\item{\code{fitness_floor}}{Numeric. The minimum fitness value in the natural and hatchery environments, i.e., fitness cannot drop below this threshold. Default is 0.5.}
}}

\section{Creating Object}{

Objects can be created by calls of the form \code{new("Hatchery")}
}

\examples{
showClass("Hatchery")
}
\keyword{classes}
