% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sBIC-Function.R
\name{sBIC}
\alias{sBIC}
\title{Compute the sBIC.}
\usage{
sBIC(X, mod)
}
\arguments{
\item{X}{the data for which the maximum likelihood estimates will be computed
for the given collection of models. To see how this data should be
formatted check the documentation for \code{setData.YourModelName} (e.g.
\code{setData.LCAs}). If X is NULL then it is assumed that data for the
model has already been set, this can be useful if you want to
compute the sBIC with the same model and data several times (perhaps
after changing some parameter of the model) without having to reset
the data and thus recompute maximum log-likelihoods.}

\item{mod}{an object representing a poset of models of the same type, e.g.
a collection of binomial mixture models. The currently implemented
models include:
\itemize{
  \item Binomial mixtures, see \code{\link{BinomialMixtures}}.
  \item Factor analysis, see \code{\link{FactorAnalyses}}.
  \item Latent class analysis, see \code{\link{LCAs}}.
  \item Latent gaussian forests, see \code{\link{LatentForests}}.
  \item Reduced rank regression, see \code{\link{ReducedRankRegressions}}.
  \item 1-dimensional gaussian mixtures, see \code{\link{GaussianMixtures}}.
}}
}
\value{
A named list containing the components
        \itemize{
         \item{logLike - the computed MLE log-likelihoods for each model.}
         \item{sBIC - the sBIC score for each model.}
         \item{BIC - the usual BIC score for each model.}
         \item{modelPoset - the input model poset mod.}
        }
}
\description{
Computes the sBIC for a given collection of models.
}

