% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsPeak.R
\name{rtmsPeakList}
\alias{rtmsPeakList}
\title{Create a list of RTMS m/z peak objects}
\usage{
rtmsPeakList(values, peakWidth = 0.1, windowWidth = NULL)
}
\arguments{
\item{values}{The m/z values that the peaks is intended to measure}

\item{peakWidth}{The width of each peak centered on \code{values}. If a single
numeric value, the lower bound of each peak will lie \code{peakWidth/2} below
the given m/z value ,and the upper bound will lie \code{peakWidth/2} above it.
If a vectorof two numeric values, the first value specifies how far below
each given m/z value the lower bounds lie, and the second value specifies how
far above each value the upper bounds lie.}

\item{windowWidth}{The width of each optional wider window around the m/z
values used to show the peaks in context.  Operates by the same principles as
\code{peakWidth} with a single value split evenly between lower and upper bounds,
and two values specifying how far below and above the m/z values each bound
lies.}
}
\value{
A list of objects of class \code{rtmsPeak}
}
\description{
Generates a list of objects of class \code{rtmsPeak} which can be used to extract
a sample or sample set from other RTMS objects.
}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
}
