## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.height = 6, fig.width = 6,
  out.width = "75%"
)

## ----packages---------------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)
data("tt", package = "rsimsum")
head(tt)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
t.test(extra ~ group, data = sleep)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s1 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", ci.limits = c("conf.low", "conf.high"), methodvar = "method", by = "dgm")
summary(s1, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s2 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", methodvar = "method", by = "dgm")
summary(s2, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s3 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", ci.limits = c(-1.5, -0.5), methodvar = "method", by = "dgm")
summary(s3, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s4 <- simsum(data = tt, estvarname = "diff", true = -1, se = "se", df = "df", methodvar = "method", by = "dgm")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
all.equal(tidy(s1), tidy(s4))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
tt$true <- -1
s5 <- simsum(data = tt, estvarname = "diff", true = "true", se = "se", ci.limits = c("conf.low", "conf.high"), methodvar = "method", by = "dgm")
summary(s5, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
summary(s2, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data("MIsim", package = "rsimsum")
data("MIsim2", package = "rsimsum")
head(MIsim)
head(MIsim2)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
s6 <- simsum(data = MIsim, estvarname = "b", true = 0.50, se = "se", methodvar = "method")
s7 <- simsum(data = MIsim2, estvarname = "b", true = 0.50, se = "se", methodvar = c("m1", "m2"))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
print(s6)
print(s7)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
all.equal(tidy(s6)$est, tidy(s7)$est)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
data("frailty", package = "rsimsum")
ms1 <- multisimsum(
  data = frailty,
  par = "par", true = c(trt = -0.50, fv = 0.75),
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist"
)
summary(ms1, stats = "bias")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
frailty$true <- ifelse(frailty$par == "trt", -0.50, 0.75)
head(frailty)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
ms2 <- multisimsum(
  data = frailty,
  par = "par", true = "true",
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist"
)
summary(ms2, stats = "bias")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
identical(tidy(ms1), tidy(ms2))

## ---------------------------------------------------------------------------------------------------------------------------------------------------
frailty$conf.low <- frailty$b - qt(1 - 0.05 / 2, df = 10) * frailty$se
frailty$conf.high <- frailty$b + qt(1 - 0.05 / 2, df = 10) * frailty$se

ms3 <- multisimsum(
  data = frailty,
  par = "par", true = "true",
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist",
  ci.limits = c("conf.low", "conf.high")
)
summary(ms3, stats = "cover")

## ---------------------------------------------------------------------------------------------------------------------------------------------------
summary(ms2, stats = "cover")

