% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{ss.options.extra}
\alias{ss.options.extra}
\title{Add lines to the current SaTScan parameter list}
\usage{
ss.options.extra(invals = NULL, section = NULL, new.section = FALSE)
}
\arguments{
\item{invals}{A character vector, which will be added to the current parameter list.}

\item{section}{A character vector of length 1 that specifies the section of
the parameter file to add the new parameters to. Sections are denoted in
the 'ssenv' object by square brackets.}

\item{new.section}{A logical variable indicating that a new section in the
parameter file should be created. (default = FALSE)}
}
\value{
\code{ss.options.extra()} returns \code{NULL} and adds lines to the parameter
set per the values of invals and section.
}
\description{
This function allows the user to add lines to the current list
of parameters. It can be used to add parameters that are not allowed using
the ss.options() function or to add comments to the parameter file.
}
\details{
The SaTScan parameters and corresponding sections that must be added
to the current parameter list using ss.options.extra() are listed below.\tabular{ll}{
    \tab  \cr
   \strong{\verb{Section=”Input”}} \tab  \cr
    \tab  \cr
   \verb{Casefile-SourceLinelistFieldMap=} \tab Comma separated list of variables in the \cr
    \tab case input data to be included in the line \cr
    \tab list output file. For each variable, \cr
    \tab includes the column number, variable \cr
    \tab type, and variable name, separated by \cr
    \tab colons. \cr
    \tab  \cr
    \tab  \cr
   \strong{\verb{Section=”Multiple Datasets”}} \tab  \cr
    \tab  \cr
   \verb{[FileType][X]=} \tab Analogous to parameters in the Input \cr
   \verb{[FileType][X]-SourceFieldMap=} \tab section, repeated for every additional \cr
   \verb{[FileType][X]-SourceDelimiter=} \tab dataset, where [FileType] is CaseFile, \cr
   \verb{[FileType][X]-SourceFirstRowHeader=} \tab ControlFile, or PopulationFile, and [X] \cr
   \verb{[FileType][X]-SourceLinelistFieldMap=} \tab may be between 2 and 20. \cr
    \tab  \cr
    \tab  \cr
   \strong{\verb{Section=”Polygons”}} \tab  \cr
    \tab  \cr
   \verb{Polygon[X]=} \tab The bound region for each Polygon, \cr
    \tab when using the Continuous Poisson \cr
    \tab probability model. \cr
}
}
\examples{
\dontrun{
# Append second data file to the Multiple Data Sets section of the parameter list
ss.options.extra(invals=list(CaseFile2="NYCfever.cas"), section="Multiple Data Sets")
print(ss.options()[67:70])

# Specify columns in the case input file to be included in the line list output file 
ss.options.extra(invals=list('CaseFile-SourceLinelistFieldMap'=strwrap(
                                "0:0:\"IndividualID\",
                                 4:1:\"DescriptiveLongitude\",
                                 2:2:\"DescriptiveLatitude\",
                                 3:3:\"AGE\",
                                 1:3:\"GENDER\"")),
                 section="Input")

# Can also append to the end of the parameter file by not specifying a section.
# This is useful for adding comments.
# Note that the input value can be specified as a character string instead of a list 
# just like 'ss.options()'
ss.options.extra(invals=";This is the end of the parameter list.")
tail(ss.options(), 3)
}
}
