% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ranked.r
\name{as_ranked}
\alias{as_ranked}
\title{Convert a tree to ranked tree}
\usage{
as_ranked(x)
}
\arguments{
\item{x}{a tree of class "phylo"}
}
\value{
a ranked tree of class "rankedPhylo"
}
\description{
Convert a tree of class "phylo" to a ranked tree of class "rankedPhylo".
}
\details{
To convert a tree to a ranked tree, the tree needs to be binary (i.e., fully resolved),
be rooted, and ultrametric. Typically, such tree would be produced by coalescent process.

Ranked trees are similar to time-trees, only instead of time, we care about the order
of the splits.
}
\examples{

# this will throw an error, the tree is not ultrametric
x = ape::rtree(5)
try(as_ranked(x))

# coalescent trees can be converted without problem
y = ape::rcoal(5)
as_ranked(y)

}
