% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{get_Bhat_comp}
\alias{get_Bhat_comp}
\title{Compute the components of the coefficient Bhat using SVD.}
\usage{
get_Bhat_comp(rsid2_1L, DUtY, nrank, tV)
}
\arguments{
\item{rsid2_1L}{A numeric vector used for each lambda value.}

\item{DUtY}{A numeric matrix (n times q).}

\item{nrank}{A numeric vector indicating the rank(s) of Bhat.}

\item{tV}{A numeric matrix.}
}
\value{
A list containing the left and right components of Bhat (\code{LeftBhatlambda_k} , \code{RightBhatlambda_k} and singular values (Bd) for GSVD of Bhat).
}
\description{
Compute the components of Bhat using SVD. In our formula, Bhat is stored as LeftBhatlambda_k (p times r matrix) and RightBhatlambda_k (q times r). Here, n is the number of samples, p is the number of variables of X, q is the number of variables of Y, and r is the specified rank in the Ridge Redundancy Analysis.
}
