% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.plot.kroclearn.R
\name{plot.cv.kroclearn}
\alias{plot.cv.kroclearn}
\title{Visualize Cross-Validation results for kernel models}
\usage{
\method{plot}{cv.kroclearn}(x, highlight = TRUE, ...)
}
\arguments{
\item{x}{A cross-validation object of class \code{"cv.kroclearn"}.}

\item{highlight}{Logical; if \code{TRUE}, mark the selected optimal
\eqn{\lambda} with a vertical dashed line with a red point (default
\code{TRUE}).}

\item{...}{Additional arguments passed to underlying \pkg{ggplot2} functions.}
}
\value{
A \code{ggplot2} object is returned and drawn to the current device.
}
\description{
Produce a visualization of cross-validation results from a fitted
\code{cv.kroclearn} object. The plot shows the mean AUC across
regularization parameters \eqn{\lambda}, with error bars reflecting
the cross-validation standard deviation. Optionally, the selected
optimal \eqn{\lambda} is highlighted with a dashed line and marker.
}
\details{
This function is a method for the generic \code{plot()} function,
designed specifically for cross-validation objects from
\code{cv.kroclearn}. The x-axis is displayed on a log scale for
\eqn{\lambda}, and the y-axis represents AUC values. Error bars show
variability across folds. This is the kernel counterpart of
\code{plot.cv.roclearn}.
}
\examples{
set.seed(123)
n <- 100
r <- sqrt(runif(n, 0.05, 1))
theta <- runif(n, 0, 2*pi)
X <- cbind(r * cos(theta), r * sin(theta))
y <- ifelse(r < 0.5, 1, -1)

cvfit <- cv.kroclearn(
  X, y,
  lambda.vec = exp(seq(log(0.01), log(5), length.out = 3)),
  kernel = "radial",
  approx=TRUE, nfolds = 2
)
plot(cvfit)
}
