% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiebreak.R
\name{tiebreak}
\alias{tiebreak}
\title{Break the ties in a given vector or between two vectors}
\usage{
tiebreak(x, y = NULL, nb_break = FALSE)
}
\arguments{
\item{x, y}{the variables containing ties.}

\item{nb_break}{if TRUE return also the number of values that have been broken}
}
\value{
After breaking the ties, either returns the \code{x} variable as a vector or returns a list containing the \code{x} and \code{y}
variables. If \code{nb_break=TRUE}, the number of values that have been broken is also an element of the list.
}
\description{
If the vector contains ties (either inside a single or between two vectors), the function breaks them using a random perturbation.
}
\details{
If \code{y=NULL} the function detects the ties in the vector \code{x}. A uniform variable on the interval \eqn{[-e^(-5),e^(-5)]} is added
to the value of all the ties but one in the vector \code{x}. If \code{y} is also provided, the function detects the ties between
\code{x} and \code{y} and break them (only in the \code{x} vector) by adding a uniform variable on the interval \eqn{[-e^(-5),e^(-5)]} to these values.
If \code{nb_break=TRUE} the result is returned as a list that also includes the number of values that have been broken.
}
\examples{
x <- c(1,2,2,3,4,5,5,5,7)
xbreak=tiebreak(x)
xbreak
#a uniform value has been added to the second, sixth and seventh value of x.
tiebreak(x,nb_break=TRUE) #3 values have been broken in x
sum(duplicated(xbreak))#check if the breaking procedure has worked.
y <- c(4,9,12,11,2,10)
xy_break=tiebreak(x,y)
xy_break$x
xy_break$y #a uniform value has been added to the second, third and fifth value of x.
xy_break$x\%in\%xy_break$y #check that no values for xbreak can be found in ybreak
tiebreak(x,y,nb_break=TRUE) #also returns the number of broken values
}
