% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gComp.R
\name{summary.gComp}
\alias{summary.gComp}
\alias{print.summary.gComp}
\title{Print a summary of a gComp class object.}
\usage{
\method{summary}{gComp}(object, ...)

\method{print}{summary.gComp}(x, ...)
}
\arguments{
\item{object}{(Required) An object of class \code{gComp} as produced by \code{gComp()}.}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{(Required) An object of class \code{summary.gComp} as produced by \code{summary.gComp()}.}
}
\value{
Returns the formula, family (with link function), contrast evaluated, resulting  
  point estimate and 95\% confidence intervals of the parameters estimated, and the  
  underlying glm used for model predictions.
}
\description{
Takes a \code{gComp} object produced by \code{gComp()} and 
  produces various useful summaries from it.
}
\examples{
## Obtain the risk difference and risk ratio for cardiovascular disease or 
## death between patients with and without diabetes, while controlling for
## age, sex, BMI, whether the individual is currently a smoker, and 
## if they have a history of hypertension.
data(cvdd)
set.seed(4832)
diabetes.result <- gComp(cvdd, 
   formula = "cvd_dth ~ DIABETES + AGE + SEX + BMI + CURSMOKE + PREVHYP",
   outcome.type = "binary", R = 20)
summary(diabetes.result)

}
\keyword{summary.gComp}
