% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{assertColumnName}
\alias{assertColumnName}
\title{Assert whether the required column names exist}
\usage{
assertColumnName(data.frame.cols, reqCols, ignore.case = FALSE)
}
\arguments{
\item{data.frame.cols}{column names of a data.frame. One can also provide a
data.frame, which may however cause worse performance since the data.frame
is copied}

\item{reqCols}{required columns}

\item{ignore.case}{logical, whether the case is considered}
}
\value{
If all required column names are present, their indices are returned
*invisibly*. Otherwise an error message is printed.
}
\description{
The function calls \code{\link{matchColumnName}} internally to match the
column names.
}
\examples{

myTestDf <- data.frame(HBV=1:3, VFB=0:2, BVB=4:6, FCB=2:4)
myFavTeams <- c("HBV", "BVB")
assertColumnName(myTestDf, myFavTeams)
myFavTeamsCase <- c("hbv", "bVb")
assertColumnName(myTestDf, myFavTeamsCase, ignore.case=TRUE)

}
