% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{Connection}
\alias{Connection}
\title{Abstract Class for Connections}
\description{
An \link[R6:R6Class]{R6::R6Class} object implementing the base \code{\link{Connection}}
class for affine connections.
}
\author{
Nicolas Guigui
}
\keyword{internal}
\section{Super class}{
\code{rgeomstats::PythonClass} -> \code{Connection}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the underlying
manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrensic} or \code{intrinsic}. Dedaults to \code{intrinsic}.}

\item{\code{default_point_type}}{A string specifying the point type. Choices are
\code{vector} or \code{matrix}. It is automatically determined depending on the
manifold.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Connection-new}{\code{Connection$new()}}
\item \href{#method-Connection-christoffels}{\code{Connection$christoffels()}}
\item \href{#method-Connection-geodesic_equation}{\code{Connection$geodesic_equation()}}
\item \href{#method-Connection-exp}{\code{Connection$exp()}}
\item \href{#method-Connection-log}{\code{Connection$log()}}
\item \href{#method-Connection-ladder_parallel_transport}{\code{Connection$ladder_parallel_transport()}}
\item \href{#method-Connection-curvature}{\code{Connection$curvature()}}
\item \href{#method-Connection-directional_curvature}{\code{Connection$directional_curvature()}}
\item \href{#method-Connection-curvature_derivative}{\code{Connection$curvature_derivative()}}
\item \href{#method-Connection-directional_curvature_derivative}{\code{Connection$directional_curvature_derivative()}}
\item \href{#method-Connection-geodesic}{\code{Connection$geodesic()}}
\item \href{#method-Connection-parallel_transport}{\code{Connection$parallel_transport()}}
\item \href{#method-Connection-injectivity_radius}{\code{Connection$injectivity_radius()}}
\item \href{#method-Connection-clone}{\code{Connection$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Connection}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$new(
  dim,
  shape = NULL,
  default_coords_type = "intrinsic",
  py_cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{extrensic} or \code{intrinsic}. Defaults to \code{intrinsic}.}

\item{\code{py_cls}}{A Python object of class \code{Connection}. Defaults to \code{NULL}
in which case it is instantiated on the fly using the other input
arguments.}

\item{\code{metric}}{A \code{\link{RiemannianMetric}} object specifying the metric to use
on the manifold. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Connection}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-christoffels"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-christoffels}{}}}
\subsection{Method \code{christoffels()}}{
Christoffel symbols associated with the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$christoffels(base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{c(dim, dim, dim)} storing the
Christoffel symbols, with the contravariant index on the first
dimension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-geodesic_equation"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-geodesic_equation}{}}}
\subsection{Method \code{geodesic_equation()}}{
Computes the geodesic ODE associated with the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$geodesic_equation(state, .time)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{A numeric array of shape \code{dim} specifying a tangent vector
to the manifold at the position specified by \code{.time}.}

\item{\code{.time}}{A numeric array of shape \code{dim} specifying a point on the
manifold at which to compute the geodesic ODE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \code{dim} storing the value of the vector
field to be integrated at position.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-exp"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-exp}{}}}
\subsection{Method \code{exp()}}{
Exponential map associated to the affine connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$exp(tangent_vec, base_point, n_steps = 100, step = "euler")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \code{dim} specifying a tangent vector
at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}

\item{\code{n_steps}}{An integer value specifying the number of discrete time steps
to take in the integration. Defaults to \code{100L}.}

\item{\code{step}}{A string specifying which numerical scheme to use for
integration. Choices are \code{euler} or \code{rk4}. Defaults to \code{euler}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Exponential map at base_point of tangent_vec computed by
integration of the geodesic equation (initial value problem), using the
christoffel symbols.
}

\subsection{Returns}{
A numeric array of shape \code{dim} storing the exponential of the
input tangent vector, which lies on on the manifold.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-log"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-log}{}}}
\subsection{Method \code{log()}}{
Logarithm map associated to the affine connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$log(
  point,
  base_point,
  n_steps = 100,
  step = "euler",
  max_iter = 25,
  verbose = FALSE,
  tol = gs$backend$atol
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \code{dim} specifying a point on the
manifold.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}

\item{\code{n_steps}}{An integer value specifying the number of discrete time steps
to take in the integration. Defaults to \code{100L}.}

\item{\code{step}}{A string specifying which numerical scheme to use for
integration. Choices are \code{euler} or \code{rk4}. Defaults to \code{euler}.}

\item{\code{max_iter}}{An integer value specifying the number of iterations.
Defaults to \code{25L}.}

\item{\code{verbose}}{A boolean specifying whether the optimizer should display
intermediate messages pertaining to its convergence. Defaults to
\code{FALSE}.}

\item{\code{tol}}{A numeric value specifying the absolute tolerance for
optimization convergence. Defaults to \code{gs$backend$atol}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Solves the boundary value problem associated to the geodesic
equation using the Christoffel symbols and conjugate gradient descent.
}

\subsection{Returns}{
A numeric array of shape \code{dim} storing the exponential of the
input tangent vector, which lies on on the manifold.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-ladder_parallel_transport"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-ladder_parallel_transport}{}}}
\subsection{Method \code{ladder_parallel_transport()}}{
Approximate parallel transport using the pole ladder scheme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$ladder_parallel_transport(
  tangent_vec,
  base_point,
  direction,
  n_rungs = 1,
  scheme = "pole",
  alpha = 1,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \code{dim} specifying a tangent vector
at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}

\item{\code{direction}}{Tangent vector at base point specifying the initial
speed of the geodesic along which to transport.}

\item{\code{n_rungs}}{A scalar integer specifying the Number of steps of the
ladder. Defaults to \code{1L}.}

\item{\code{scheme}}{A string specifying the scheme to use for the construction
of the ladder at each step. Choices are either \code{pole} or \code{schild}.
Defaults to \code{pole}.}

\item{\code{alpha}}{A numeric value specifying the exponent for the scaling of
the vector to transport. Must be greater or equal to 1 and
\insertCite{guigui2022numerical;textual}{rgeomstats} proved that \code{alpha = 2} is optimal. Defaults to \code{2}.}

\item{\code{...}}{Extra arguments to be passed to calls to \verb{$exp()} and \verb{$log()}
in auxiliary single ladder step functions.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Approximate parallel transport using either the pole ladder or
the Schild's ladder scheme
\insertCite{lorenzi2014efficient}{rgeomstats}. Pole ladder is exact in
symmetric spaces and of order two in general while Schild's ladder is a
first order approximation \insertCite{guigui2022numerical}{rgeomstats}.
Both schemes are available on any affine connection manifolds whose
exponential and logarithm maps are implemented. \code{tangent_vec} is
transported along the geodesic starting at the \code{base_point} with
initial tangent vector \code{direction}.
\subsection{References}{

\insertCited{}
}
}

\subsection{Returns}{
A named list with 3 components:
\itemize{
\item \code{transported_tangent_vector}: Approximation of the parallel transport
of the input tangent vector.
\item \code{trajectory} : A list of length \code{n_steps} storing the geodesics of the
construction, only if \code{return_geodesics = TRUE} in the step function. The
geodesics are methods of the class connection.
\item \code{end_point}:
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-curvature"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-curvature}{}}}
\subsection{Method \code{curvature()}}{
Computes the curvature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$curvature(tangent_vec_a, tangent_vec_b, tangent_vec_c, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_b}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_c}}{Tangent vector at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For three vector fields \eqn{X|_P = \mathrm{tangent\_vec\_a}},
\eqn{Y|_P = \mathrm{tangent\_vec\_b}}, \eqn{Z|_P =
  \mathrm{tangent\_vec\_c}} with tangent vector specified in argument at
the base point \eqn{P}, the curvature is defined by \deqn{R(X,Y)Z =
  \nabla_{[X,Y]}Z - \nabla_X\nabla_Y Z + \nabla_Y\nabla_X Z.}
}

\subsection{Returns}{
Tangent vector at \code{base_point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-directional_curvature"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-directional_curvature}{}}}
\subsection{Method \code{directional_curvature()}}{
Computes the directional curvature (tidal force operator).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$directional_curvature(tangent_vec_a, tangent_vec_b, base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_b}}{Tangent vector at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For two vector fields \eqn{X|_P = \mathrm{tangent\_vec\_a}} and
\eqn{Y|_P = \mathrm{tangent\_vec\_b}} with tangent vector specified in
argument at the base point \eqn{P}, the directional curvature, better
known in relativity as the tidal force operator, is defined by
\deqn{R_Y(X) = R(Y,X)Y.}
}

\subsection{Returns}{
Tangent vector at \code{base_point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-curvature_derivative"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-curvature_derivative}{}}}
\subsection{Method \code{curvature_derivative()}}{
Computes the covariant derivative of the curvature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$curvature_derivative(
  tangent_vec_a,
  tangent_vec_b,
  tangent_vec_c,
  tangent_vec_d,
  base_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_b}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_c}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_d}}{Tangent vector at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For four vector fields \eqn{H|_P = \mathrm{tangent\_vec\_a}},
\eqn{X|_P = \mathrm{tangent\_vec\_b}}, \eqn{Y|_P =
  \mathrm{tangent\_vec\_c}}, \eqn{Z|_P = \mathrm{tangent\_vec\_d}} with
tangent vector value specified in argument at the base point \eqn{P},
the covariant derivative of the curvature \eqn{(\nabla_H R)(X, Y) Z
  |_P} is computed at the base point \eqn{P}.
}

\subsection{Returns}{
Tangent vector at \code{base_point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-directional_curvature_derivative"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-directional_curvature_derivative}{}}}
\subsection{Method \code{directional_curvature_derivative()}}{
Computes the covariant derivative of the directional
curvature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$directional_curvature_derivative(
  tangent_vec_a,
  tangent_vec_b,
  base_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec_a}}{Tangent vector at \code{base_point}.}

\item{\code{tangent_vec_b}}{Tangent vector at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For two vector fields \eqn{X|_P = \mathrm{tangent\_vec\_a}},
\eqn{Y|_P = \mathrm{tangent\_vec\_b}} with tangent vector value
specified in argument at the base point \eqn{P}, the covariant
derivative (in the direction \eqn{X}) \eqn{(\nabla_X R_Y)(X) |_P =
  (\nabla_X R)(Y, X) Y |_P} of the directional curvature (in the
direction \eqn{Y}) \eqn{R_Y(X) = R(Y, X) Y} is a quadratic tensor in
\eqn{X} and \eqn{Y} that plays an important role in the computation of
the moments of the empirical Fréchet mean
\insertCite{pennec2019curvature}{rgeomstats}.
\subsection{References}{

\insertCited{}
}
}

\subsection{Returns}{
Tangent vector at \code{base_point}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-geodesic"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-geodesic}{}}}
\subsection{Method \code{geodesic()}}{
Generates parametrized function for the geodesic curve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$geodesic(
  initial_point,
  end_point = NULL,
  initial_tangent_vec = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_point}}{Point on the manifold specifying the initial point
of the geodesic.}

\item{\code{end_point}}{Point on the manifold specifying the end point of the
geodesic. Defaults to \code{NULL}, in which case an initial tangent vector
must be given.}

\item{\code{initial_tangent_vec}}{Tangent vector at base point specifying the
initial speed of the geodesics. Defaults to \code{NULL}, in which case an
end point must be given and a logarithm is computed.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Geodesic curve defined by either:
\itemize{
\item an initial point and an initial tangent vector,
\item an initial point and an end point.
}
}

\subsection{Returns}{
A function representing the time-parametrized geodesic curve. If
a list of initial conditions is passed, the output list will contain,
for each time point, a list with the geodesic values each initial
condition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-parallel_transport"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-parallel_transport}{}}}
\subsection{Method \code{parallel_transport()}}{
Computes the parallel transport of a tangent vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$parallel_transport(
  tangent_vec,
  base_point,
  direction = NULL,
  end_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \code{dim} specifying a tangent vector
at \code{base_point}.}

\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}

\item{\code{direction}}{Tangent vector at base point specifying the point along
which the parallel transport is computed. Defaults to \code{NULL}.}

\item{\code{end_point}}{Point on the manifold specifying the point to transport
to. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Closed-form solution for the parallel transport of a tangent
vector along the geodesic between two points \code{base_point} and
\code{end_point} or alternatively defined by \eqn{t \mapsto
  \exp_\mathrm{base_point} (t \mathrm{direction})}.
}

\subsection{Returns}{
Tangent vector transported at \eqn{t \mapsto
  \exp_\mathrm{base_point} (t \mathrm{direction})}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-injectivity_radius"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-injectivity_radius}{}}}
\subsection{Method \code{injectivity_radius()}}{
Computes the radius of the injectivity domain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$injectivity_radius(base_point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_point}}{A numeric array of shape \code{dim} specifying a base point on
the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This is is the supremum of radii r for which the exponential
map is a diffeomorphism from the open ball of radius r centered at the
base point onto its image.
}

\subsection{Returns}{
A numeric value representing the injectivity radius.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Connection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Connection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
