#' Extract alignment within detection windows
#'
#' @param aln.df A data frame of alignment
#' @param ref.start The start position of reference sequence in the alignment
#' @param ref.end The end position of reference sequence in the alignment
#' @param roi.start The start position of detection windows
#' @param roi.end The end position of detection windows
#' 
#' @return A data frame of alignment within detection windows
#' 
#' @examples
#' \dontrun{
#'     extractDetectionWindow()
#' }
#'
#' @noRd
extractDetectionWindow <- function(aln.df, ref.start, ref.end, roi.start, roi.end){
    
	if( roi.start < ref.start ){
		p1 <- which(aln.df$ref_pos==ref.start)
	}else{
		p1 <- which(aln.df$ref_pos==roi.start)
		if( aln.df$cigar[p1]=="D" & is.na(aln.df$del[p1]) ){
			p1 <- max( which( aln.df$cigar[1:p1]=="D" & !is.na(aln.df$del[1:p1]) ) )
		}
	}
    
	if( roi.end > ref.end ){
		p2 <- which(aln.df$ref_pos==ref.end)
	}else{
		p2 <- which(aln.df$ref_pos==roi.end)
		if( aln.df$cigar[p2]=="D" ){
		    if( is.na(aln.df$del[p2]) ){
		        p2 <- max( which( aln.df$cigar[1:p2]=="D" & !is.na(aln.df$del[1:p2]) ) )
		    }
		    if( is.na(aln.df$ins[p2]) ){
		        ins.ext <- 0
		    }else{
		        ins.ext <- nchar(aln.df$ins[p2])
		    }
		    p2 <- p2 + aln.df$del[p2] - 1 + ins.ext
		}
	}
	
	roi.aln.df <- aln.df[ p1:p2, ]
	
	if( roi.aln.df$cigar[nrow(roi.aln.df)]=="M" & !is.na(roi.aln.df$ins[nrow(roi.aln.df)]) ){
		roi.aln.df$ins[nrow(roi.aln.df)] <- NA
	}
	
	return(roi.aln.df)
}
