\name{abic.expo.weibull}

\alias{abic.expo.weibull}

\title{Akaike information criterion (AIC) and Bayesian information criterion (BIC)
for Exponentiated Weibull(EW) distribution}

\description{
The function \code{abic.expo.weibull()} gives the  \code{loglikelihood}, \code{AIC} and \code{BIC} values
assuming an Exponentiated Weibull(EW) distribution with parameters alpha and theta.}

\usage{abic.expo.weibull(x, alpha.est, theta.est)}

\arguments{
  \item{x}{vector of observations}
  \item{alpha.est}{estimate of the parameter alpha}
  \item{theta.est}{estimate of the parameter theta}
}

\value{
The function \code{abic.expo.weibull()} gives the  \code{loglikelihood}, \code{AIC} and \code{BIC} values.
}

\references{
Akaike, H. (1978).
\emph{A new look at the Bayes procedure}, Biometrika, 65, 53-59.

Claeskens, G.  and Hjort, N. L. (2008).
\emph{Model Selection and Model Averaging}, Cambridge University Press, London.

Konishi., S. and Kitagawa, G.(2008).
\emph{Information Criteria and Statistical Modeling}, Springer Science+Business Media, LLC.

Schwarz, S. (1978).
\emph{Estimating the dimension of the model}, Annals of Statistics, 6, 461-464.

Spiegelhalter, D. J., Best, N. G., Carlin, B. P. and van der Linde, A. (2002).
\emph{Bayesian measures of complexity and fit}, Journal of the Royal Statistical Society Series B 64, 1-34.
}

\seealso{
\code{\link{pp.expo.weibull}} for \code{PP} plot and \code{\link{qq.expo.weibull}} for \code{QQ} plot
}

\examples{
## Load data sets
data(stress)
## Maximum Likelihood(ML) Estimates of alpha & theta for the data(stress)
## Estimates of alpha & theta using 'maxLik' package
## alpha.est =1.026465, theta.est = 7.824943

## Values of AIC, BIC and LogLik for the data(stress)
abic.expo.weibull(stress, 1.026465, 7.824943)
}

\keyword{models}
