% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_plot_data.R
\name{create_surface_data}
\alias{create_surface_data}
\title{Create data frame used to plot a surface of predicted y values}
\usage{
create_surface_data(data, model)
}
\arguments{
\item{data}{A data frame being used to estimate the regression model}

\item{model}{A glm with exactly two x variables}
}
\value{
A data frame with generated values for two x variables, as well as the
predicted y values and predicted
confidence intervals for each pair of x values. These can be used to plot
the estimated regression surface and confidence interval surfaces.
}
\description{
Create data frame used to plot a surface of predicted y values.
There can be only exactly 2 columns of x values. The predicted y values
can be estimated from an lm or glm model. Interaction terms are allowed, as are
weights.
}
\examples{
mymodel <- lm(length ~ isFemale_num + isMale_num,
              data = hair_data)
surface_data <- create_surface_data(data = hair_data,
                                    model = mymodel)
}
