% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqc_Plot.R
\name{eqc_Plot}
\alias{eqc_Plot}
\title{Enhanced quality control plots for daily precipitation}
\usage{
eqc_Plot(xts_obj)
}
\arguments{
\item{xts_obj}{xts of a single time series}
}
\description{
The function create a matrix plot of the enhanced quality control tests for daily precipitation
}
\details{
Six plots are built based on daily precipitation: time series, truncation, time series (threshold = 5 mm), small gaps, precision and rounding patterns and weekly cycle.
These provide a visual inspection (Hunziker et al., 2017) but also how the automatic application  (Huerta et al., 2020) of the enhanced quality control is applied.
}
\examples{
\dontrun{
set.seed(123)

# creating fake daily precipitation data
dates_t <- seq(as.Date("1980-01-01"), as.Date("2015-12-31"), by = "day")
prec <- round(rnorm(length(dates_t), mean = 1.2, sd = 6), 1)
prec[prec<0] <- 0
xts_obj <- xts::xts(prec, dates_t)
names(xts_obj) <- "prec"

# enhanced qc plots
eqc_Plot(xts_obj)

# it also work if there is some empty data (but not if all is NA)
xts_obj["1990/2010"] <- NA
eqc_Plot(xts_obj)
}

}
\references{
Hunziker, S., Gubler, S., Calle, J., Moreno, I., Andrade, M., Velarde, F., ... & Brönnimann, S. (2017). Identifying, attributing, and overcoming common data quality issues of manned station observations. https://doi.org/10.1002/joc.5037

Huerta, A., Serrano-Notivoli, R., & Brönnimann, S. (2024). SC-PREC4SA: A serially complete daily precipitation dataset for South America. https://doi.org/10.31223/X57D8R
}
