% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{aoo}
\alias{aoo}
\title{Area of Occupancy (AOO).}
\usage{
aoo(spData, cellSize = 2)
}
\arguments{
\item{spData}{One of three options: 1) matrix of longitude and latitude (two columns) of each occurrence record; 2) matrix of easting and northing (two columns, e.g. UTM) of each occurrence record in meters;  3) RasterLayer object of predicted distribution (either 0/1 or probabilistic values).}

\item{cellSize}{A numeric value in km determining the side of the grid square used to calculate AOO.}
}
\value{
A single value in km2 or a vector with lower confidence limit, consensus and upper confidence limit (probabilities 0.975, 0.5 and 0.025 respectively).
}
\description{
Calculates the Area of Occupancy of a species based on either known records or predicted distribution.
}
\details{
AOO is calculated as the area of all known or predicted cells for the species. By default the resolution will be 2x2km as required by the IUCN.
}
\examples{
range = red.examples("red.range")
aoo(range)
}
