% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparers.R
\name{ignore_differences}
\alias{ignore_differences}
\alias{sides_similar}
\title{Example Object and Side Effect Comparers}
\usage{
ignore_differences(x, y)

sides_similar(x, y)
}
\arguments{
\item{x}{prototype or part thereof}

\item{y}{object under scrutiny or part thereof}
}
\value{
Each comparer should yield \code{TRUE} if the test condition
is considered met or anything else otherwise.
However, it is highly recommended that in the latter case,
a single string with a short
summary of the differences be returned, as in \code{\link[base]{all.equal}}.
}
\description{
Example two-argument functions to compare direct or indirect effects
of two test descriptors (see \code{\link{P}} and \code{\link{R}}).
These can be passed as \code{value_comparer} and \code{sides_comparer}
to \code{\link{E}}.
}
\details{
Notable built-in (base R) comparers include \code{\link[base]{identical}}
(the strictest possible)
and \code{\link[base]{all.equal}} (can ignore, amongst others,
round-off errors; note that it is an S3 generic).

\code{ignore_differences} is a dummy comparer that always returns
\code{TRUE}. Hence, it does not discriminate between anything.

\code{sides_similar} is useful when comparing side effect lists.
It defines the following semantics for the prototypical values:
\itemize{
\item non-existent, \code{NULL}, or \code{FALSE} -- a side effect must
    not occur,
\item \code{NA} -- ignore whatsoever,
\item \code{TRUE} -- a side effect occurs, but the details are irrelevant
   (e.g., 'some warning' as opposed to \code{"NaNs produced"})
\item otherwise -- a character vector with message(s) matched exactly.
}

You can define any comparers of your own liking:
the possibilities are endless. For example:
\itemize{
\item a comparer for side effects based on regular expressions
    or wildcards (e.g., \code{".not converged.*"}),
\item a comparer that tests whether all elements in a vector are
    equal to \code{TRUE},
\item a comparer that verifies whether each element in a vector falls into
    a specified interval,
\item a comparer that ignores all the object attributes (possibly
    in combination with other comparers),
}
and so forth.
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}
}
