% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nlum_stars.R
\name{read_nlum_stars}
\alias{read_nlum_stars}
\title{Read ABARES' National Scale "Land Use of Australia" Data Using stars}
\source{
\describe{
\item{Y201011}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_ALUMV8_2010_11_alb_package_20241128.zip}}
\item{Y201516}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_ALUMV8_2015_16_alb_package_20241128.zip}}
\item{Y202021}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_ALUMV8_2020_21_alb_package_20241128.zip}}
\item{C201021}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_CHANGE_SIMP_2011_to_2021_alb_package_20241128.zip}}
\item{T201011}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_INPUTS_2010_11_geo_package_20241128.zip}}
\item{T201516}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_INPUTS_2015_16_geo_package_20241128.zip}}
\item{T202021}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_INPUTS_2020_21_geo_package_20241128.zip}}
\item{P201011}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_AgProbabilitySurfaces_2010_11_geo_package_20241128.zip}}
\item{P201516}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_AgProbabilitySurfaces_2015_16_geo_package_20241128.zip}}
\item{P202021}{\url{https://www.agriculture.gov.au/sites/default/files/documents/NLUM_v7_250_AgProbabilitySurfaces_2020_21_geo_package_20241128.zip}}
}.
}
\usage{
read_nlum_stars(data_set = NULL, x = NULL, ...)
}
\arguments{
\item{data_set}{A string value indicating the GeoTIFF desired for download.
One of:
\describe{
\item{Y201011}{Land use of Australia 2010–11}
\item{Y201516}{Land use of Australia 2015–16}
\item{Y202021}{Land use of Australia 2020–21}
\item{C201121}{Land use of Australia change}
\item{T201011}{Land use of Australia 2010–11 thematic layers}
\item{T201516}{Land use of Australia 2015–16 thematic layers}
\item{T202021}{Land use of Australia 2020–21 thematic layers}
\item{P201011}{Land use of Australia 2010–11 agricultural commodities probability grids}
\item{P201516}{Land use of Australia 2015–16 agricultural commodities probability grids}
\item{P202021}{Land use of Australia 2020–21 agricultural commodities probability grids}
}.
This argument is ignored if \code{x} is provided.}

\item{x}{A character string of a file path to a local zip file that has
been downloaded outside of R that contains the \acronym{NLUM} data.
This argument is ignored if \code{data_set} is provided.}

\item{...}{Additional arguments passed to \code{\link[stars:read_stars]{stars::read_stars()}}, for \emph{e.g.},
\code{RAT} if you wish to set the active category when loading any of the
available GeoTIFF files that are encoded with a raster attribute table.}
}
\value{
a \CRANpkg{stars} object that may be one or many layers depending
upon the requested data set.
}
\description{
Download and import national scale "Land Use of Australia v7" GeoTIFFs as a
\CRANpkg{stars} object.
}
\details{
From the
\href{https://www.agriculture.gov.au/abares/aclump/land-use/land-use-of-australia-2010-11-to-2020-21}{ABARES website}:
"The \emph{Land use of Australia 2010–11 to 2020–21} data package consists
of seamless continental rasters that present land use at national scale for
2010–11, 2015–16 and 2020–21 and the associated change between each target
period.  Non-agricultural land uses are mapped using 7 thematic layers,
derived from existing datasets provided by state and territory jurisdictions
and external agencies. These 7 layers are: protected areas, topographic
features, land tenure, forest type, catchment scale land use, urban
boundaries, and stock routes. The agricultural land uses are based on the
Australian Bureau of Statistics’ 2010–11, 2015–16 and 2020–21 agricultural
census data; with spatial distributions modelled using Terra Moderate
Resolution Imaging Spectroradiometer (\acronym{MODIS}) satellite imagery and
training data, assisted by spatial constraint layers for cultivation,
horticulture, and irrigation.
Land use is specified according to the Australian Land Use and Management
(\acronym{ALUM}) Classification version 8. The same method is applied to all
target periods using representative national datasets for each period, where
available. All rasters are in GeoTIFF format with geographic coordinates in
Geocentric Datum of Australian 1994 (GDA94) and a 0.002197 degree
(~250 metre) cell size.
The \emph{Land use of Australia 2010–11 to 2020–21} data package is a product
of the Australian Collaborative Land Use and Management Program. This data
package replaces the Land use of Australia 2010–11 to 2015–16 data package,
with updates to these time periods."
-- \acronym{ABARES}, 2024-11-28
}
\note{
The raster will load with the default category for each data set, but you can
specify a different category to use by passing the \code{RAT} argument through
the \code{...}.  To see which categories are available, please refer
to the metadata for these data.  The \acronym{PDF} can be accessed in your
default \acronym{PDF} viewer by using \code{\link[=view_nlum_metadata_pdf]{view_nlum_metadata_pdf()}}.
}
\section{proj}{

Which should you choose?
If you need accurate area calculations (\emph{e.g.}, hectares of land use),
use Albers.
If you just need global compatibility or want to overlay with other lat/long
datasets, use Geographic.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

nlum_stars <- read_nlum_stars("Y202021")

nlum_stars

plot(nlum_stars)
\dontshow{\}) # examplesIf}
}
\references{
ABARES 2024, Land use of Australia 2010–11 to 2020–21, Australian Bureau of
Agricultural and Resource Economics and Sciences, Canberra, November, CC BY
4.0. \doi{10.25814/w175-xh85}
}
\seealso{
Other nlum: 
\code{\link{read_nlum_terra}()},
\code{\link{view_clum_metadata_pdf}()},
\code{\link{view_nlum_metadata_pdf}()}
}
\concept{nlum}
