% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.abares-package.R
\docType{package}
\name{read.abares-package}
\alias{read.abares}
\alias{read.abares-package}
\title{read.abares: Read Data from the Australian Bureau of Agricultural and Resource Economics and Sciences (ABARES) and Australian Bureau of Statistics (ABS)}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Download and import agricultural data from the Australian Bureau of Agricultural and Resource Economics and Sciences (ABARES) \url{https://www.agriculture.gov.au/abares} and Australian Bureau of Statistics (ABS) \url{https://www.abs.gov.au}. Data types serviced include spreadsheets, comma separated value (CSV) files, geospatial data including shape files and geotiffs covering topics including broadacre crops, livestock, soil data, commodities and more. Unifies field names and formats for data interoperability making analysis easier by standardising names between data formats. Also simplifies importing geospatial data as well as correcting issues in the geospatial data upon import.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/read.abares}
  \item \url{https://docs.ropensci.org/read.abares/}
  \item Report bugs at \url{https://github.com/ropensci/read.abares/issues}
}

}
\author{
\strong{Maintainer}: Adam H. Sparks \email{adamhsparks@gmail.com} (\href{https://orcid.org/0000-0002-0061-8359}{ORCID})

Other contributors:
\itemize{
  \item Curtin University (\href{https://ror.org/02n415q13}{ROR}) (http://www.curtin.edu.au/) [funder, copyright holder]
  \item Grains Research and Development Corporation (\href{https://ror.org/02xwr1996}{ROR}) (GRDC Project CUR2210-005OPX (AAGI-CU)) [funder, copyright holder]
  \item Jacob Wujciak-Jens \email{jacob@wujciak.de} (\href{https://orcid.org/0000-0002-7281-3989}{ORCID}) (Assisted with troubleshooting formatting in documentation to display '<' and '>' properly) [contributor]
  \item Nicholas Potter \email{econpotter@gmail.com} (\href{https://orcid.org/0000-0002-3410-3732}{ORCID}) (rOpenSci Review https://github.com/ropensci/software-review/issues/667) [reviewer]
  \item María Paula Caldas \email{mpaulacaldas@gmail.com} (\href{https://orcid.org/0000-0002-1938-6471}{ORCID}) (rOpenSci Review https://github.com/ropensci/software-review/issues/667) [reviewer]
}

}
\keyword{internal}
