% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{group_border_sort}
\alias{group_border_sort}
\title{Add a styled border beneath rows of specified groups on sort. Must be placed within reactable::rowStyle().
Credit to Greg Lin, creator of {reactable} for writing the JS function.}
\usage{
group_border_sort(
  columns = NULL,
  border_width = "thin",
  border_color = "#777",
  border_style = "solid"
)
}
\arguments{
\item{columns}{Name of the column(s).
Can provide up to four column names.}

\item{border_width}{The width of the border.
Options are "thin", "medium", "thick", or a numeric value such as "2px".
May be specified using one, two, three, or four values.
See [CSS border-width](https://developer.mozilla.org/en-US/docs/Web/CSS/border-width) for more options.
Default is 'thin'.}

\item{border_color}{The color of the border.
May be specified using one, two, three, or four values.
See [CSS border-color](https://developer.mozilla.org/en-US/docs/Web/CSS/border-color) for more options.
Default is #777.}

\item{border_style}{The style of the border.
Options are "solid", "dashed", "dotted", "double", "groove", "ridge", "inset", "outset", "none", or "hidden".
May be specified using one, two, three, or four values.
See [CSS border-style](https://developer.mozilla.org/en-US/docs/Web/CSS/border-style) for more options.
Default is 'solid'.}
}
\value{
a function that applies a bottom border to each group in a column of a reactable table.
}
\description{
Add a styled border beneath rows of specified groups on sort. Must be placed within reactable::rowStyle().
Credit to Greg Lin, creator of {reactable} for writing the JS function.
}
\examples{
data <- MASS::Cars93[1:20, c("Manufacturer", "Model", "Type", "MPG.city")]

## Add border beneath each unique group within a column on sort:
reactable(data,
pagination = FALSE,
rowStyle = group_border_sort("Manufacturer")
)

## Can specify up to 4 columns:
reactable(data,
pagination = FALSE,
rowStyle = group_border_sort(columns = c("Manufacturer","Model","Type"))
)

## Apply styles to the border:
reactable(data,
pagination = FALSE,
rowStyle = group_border_sort(columns = c("Manufacturer","Model","Type"),
                             border_color = "red",
                             border_style = "dashed",
                             border_width = "3px")
)
}
