% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{google_font}
\alias{google_font}
\title{Apply a font from Google Fonts <https://fonts.google.com/> to the table.}
\usage{
google_font(
  table = NULL,
  font_family = "Poppins",
  font_weight = 400,
  font_style = "normal"
)
}
\arguments{
\item{table}{Null.}

\item{font_family}{Color of the font for the text within the table.
Default is #222222.}

\item{font_weight}{The numeric weight of the font.
Must be a value between 100 and 900.
Note: not every font on Google Fonts has all font weights available.
Please check <https://fonts.google.com/> for available weights for desired font family.
Default is 400.}

\item{font_style}{Style of the text font.
Options are "normal" or "italic".
Default is "normal".}
}
\value{
a function that applies a font to a reactable table.
}
\description{
Apply a font from Google Fonts <https://fonts.google.com/> to the table.
}
\examples{
\dontrun{
data <- iris[10:29, ]

## Default 'Poppins' font from Google Fonts
reactable(data) \%>\%
google_font()

## Apply styles to fonts
reactable(data) \%>\%
google_font("Roboto Mono", font_weight = 500, font_style = "italic")
}
}
