% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdi_functions.R
\name{rdiLadder}
\alias{rdiLadder}
\title{RDI ladder}
\usage{
rdiLadder(n, ngenes = NULL, baseVects = NULL, diffPoints = NULL,
  units = c("lfc", "pct"), ...)
}
\arguments{
\item{n}{the repertoire size; alternatively, an rdiModel object as created by
\link{rdiModel}.}

\item{ngenes}{numeric vector indicating the number of genes in each chain.
If baseVect is not provided, this parameter will be used to 
generate a base prevalence vector for each of the genes.}

\item{baseVects}{A vector or list of vectors representing the total prevalence of 
each gene (for each chain) in the dataset. See \link{rdiModel} for details.}

\item{diffPoints}{numeric vector; each value specifices either a log2 fold change or 
percent deviation value (depending on the 'units') at which 
the RDI ladder will be calculated.}

\item{units}{String; either "lfc" or "pct", depending on what transform was used
in the original RDI calculations. See Details.}

\item{...}{Additional parameters to be passed to \link{rdiModel}}
}
\value{
A list of the same length as diffPoints, with each entry in the list containing
the mean RDI value and standard deviation corresponding to a given true difference value.
}
\description{
Function for creating the RDI ladder for a specific number of sequences
}
\details{
Because RDI values vary according to the number of genes and size of the repertoires,
they are not useful as numbers by themselves. Instead, it is useful to compare them 
with estimates of the true difference between the two repertoires. 
This function uses the models generated by \link{rdiModel} to generate estimated
RDI values corresponding to a set of pre-defined true distance (log-fold change or 
percent) values. This function is primarily meant to be used in conjunction with
\link{plotRDIladder} in order to add a useful reference point for RDI values. 

The units used for the RDI model should always match the units used to generate your
RDI values. For more details on units, refer to the details of \link{calcRDI}
}
\seealso{
\link{plotRDIladder}, \link{rdiModel}, \link{rdiAxis}
}
