% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertu.R
\name{cconv}
\alias{cconv}
\alias{convertu}
\title{Convert text into target classifications (e.g., ISO 3166-1) using a JSON
mapping with regular expressions.}
\usage{
cconv(
  data = NULL,
  json_file = NULL,
  info = FALSE,
  dump = FALSE,
  to = NULL,
  text = character()
)

convertu(
  data = NULL,
  json_file = NULL,
  info = FALSE,
  dump = FALSE,
  to = NULL,
  text = character()
)
}
\arguments{
\item{data}{list of named lists (optional). A complete classification
mapping provided directly. If supplied without \code{json_file}, this data will
be used in-memory for conversions without reading from disk. If both
\code{data} and \code{json_file} are supplied, the data is written to \code{json_file}
and the file path is returned.}

\item{json_file}{character(1). Path to the classification JSON file.
If not provided, the default bundled \code{classification.json} is used
(resolved via \code{system.file("extdata", "classification.json", package="rconvertu")}). When \code{data} is not supplied, this file is loaded
and used as the source mapping. When \code{data} is supplied along with
\code{json_file}, the data is written to \code{json_file}.}

\item{info}{logical(1). If \code{TRUE}, return only metadata/sources entries.
No conversion is performed.}

\item{dump}{logical(1). If \code{TRUE}, return the full mapping (filtered of
metadata/sources). No conversion is performed.}

\item{to}{character(1). Target field name to return from matched records
(e.g., \code{"iso3"}).}

\item{text}{character(). One or more input strings to convert. A single
string input yields a single string output; a vector yields a character
vector of converted results.}
}
\value{
If \code{info = TRUE} or \code{dump = TRUE}, returns a list of records.
Otherwise, returns a character vector of converted values:
\itemize{
\item If \code{length(text) == 1}, returns a length-one character scalar.
\item If no match is found for an input, the original value is returned.
}
}
\description{
Pure-R implementation of the \strong{convertu} API.
Converts text into a target classification using a JSON mapping, or
returns mapping/metadata (\code{info} / \code{dump} modes).
}
\details{
Behavior:
\itemize{
\item \code{info = TRUE} → returns only metadata and sources entries (no conversion).
\item \code{dump = TRUE} → returns the full classification (no metadata/sources).
\item Otherwise → converts \code{text} using regex-based matching and returns the
value from the requested field \code{to}.
}
}
\section{Data template (list of named lists)}{

The classification is a top-level list with three kinds of elements:
\enumerate{
\item Many record elements (unnamed or named) with fields:
\itemize{
\item \code{regex}   (chr): pattern matching the input text.
\item \code{name_en} (chr): English short name.
\item \code{name_fr} (chr): French short name (optional).
\item \code{iso3}    (chr): alpha-3 code (example field).
\item \code{iso2}    (chr): alpha-2 code (example field).
\item \code{isoN}    (chr): numeric code (example field).
}
\item One element \code{metadata} (named list) mapping field names to their
human-readable descriptions:
\preformatted{
   metadata = list(
     name_en = "English short name",
     name_fr = "French short name",
     iso3    = "alpha-3 code",
     iso2    = "alpha-2 code",
     isoN    = "numeric"
   )
   }
\item One element \code{sources} (character vector) with references:
\preformatted{
   sources = c(
     "https://www.iso.org/iso-3166-country-codes.html",
     "https://en.wikipedia.org/wiki/List_of_alternative_country_names"
   )
   }
}
}

\examples{
# Single conversion
cconv(to = "iso3", text = "Czech Republic")

# Multiple conversions
cconv(to = "iso3", text = c("Czech Republic", "Slovakia"))

# Show bundled metadata
cconv(info = TRUE)

# Dump classification mapping only
cconv(dump = TRUE)

}
