% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.spdRC}
\alias{plot.spdRC}
\title{Plot \code{spdRC} class objects}
\usage{
\method{plot}{spdRC}(
  x,
  calendar = "BP",
  col.obs = "black",
  lwd.obs = 0.5,
  xaxs = "i",
  yaxs = "i",
  xlim = NA,
  ...
)
}
\arguments{
\item{x}{\code{spdRC} class object containing geometric growth rates.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{col.obs}{Line colour for the observed SPD}

\item{lwd.obs}{Line width for the observed SPD}

\item{xaxs}{The style of x-axis interval calculation (see \code{\link[graphics]{par}})}

\item{yaxs}{The style of y-axis interval calculation (see \code{\link[graphics]{par}})}

\item{xlim}{Limits for the x axis.}

\item{...}{Additional arguments affecting the plot.}
}
\description{
Plot rates of change between time-blocks
}
\seealso{
\code{\link[rcarbon]{spd2rc}}
}
